/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.persist.policies.ScriptPolicy;

public class ScriptPolicyTest {
    @Test
    public void testScriptPolicy() throws Exception {
        OnmsNode node1 = new OnmsNode();
        node1.setNodeId("1");
        node1.setLocation(new OnmsMonitoringLocation("Default", ""));
        OnmsIpInterface iface1_1 = new OnmsIpInterface();
        iface1_1.setIpAddress(InetAddress.getByName("172.16.0.1"));
        iface1_1.setIsSnmpPrimary(PrimaryType.PRIMARY);
        OnmsIpInterface iface1_2 = new OnmsIpInterface();
        iface1_2.setIpAddress(InetAddress.getByName("172.17.0.1"));
        iface1_2.setIsSnmpPrimary(PrimaryType.SECONDARY);
        OnmsIpInterface iface1_3 = new OnmsIpInterface();
        iface1_3.setIpAddress(InetAddress.getByName("192.168.0.10"));
        iface1_3.setIsSnmpPrimary(PrimaryType.NOT_ELIGIBLE);
        node1.addIpInterface(iface1_1);
        node1.addIpInterface(iface1_2);
        node1.addIpInterface(iface1_3);
        node1.setForeignSource("nodes");
        node1.setForeignId("1");
        node1.setLabel("Node-1-Foo");
        OnmsNode node2 = new OnmsNode();
        node2.setNodeId("2");
        node2.setLocation(new OnmsMonitoringLocation("Default", ""));
        OnmsIpInterface iface2_1 = new OnmsIpInterface();
        iface2_1.setIpAddress(InetAddress.getByName("172.16.0.1"));
        iface2_1.setIsSnmpPrimary(PrimaryType.PRIMARY);
        OnmsIpInterface iface2_2 = new OnmsIpInterface();
        iface2_2.setIpAddress(InetAddress.getByName("172.17.0.1"));
        iface2_2.setIsSnmpPrimary(PrimaryType.SECONDARY);
        OnmsIpInterface iface2_3 = new OnmsIpInterface();
        iface2_3.setIpAddress(InetAddress.getByName("192.168.0.20"));
        iface2_3.setIsSnmpPrimary(PrimaryType.NOT_ELIGIBLE);
        node2.addIpInterface(iface2_1);
        node2.addIpInterface(iface2_2);
        node2.addIpInterface(iface2_3);
        node2.setForeignSource("nodes");
        node2.setForeignId("2");
        node2.setLabel("Node-2-Bar");
        ScriptPolicy p = new ScriptPolicy(Paths.get("src", "test", "resources").toAbsolutePath());
        p.setLabel("~.*Foo$");
        p.setMatchBehavior("ALL_PARAMETERS");
        p.setScript("policy.groovy");
        node1 = (OnmsNode)p.apply((Object)node1);
        Assert.assertEquals((Object)PrimaryType.NOT_ELIGIBLE, (Object)node1.getIpInterfaceByIpAddress("172.16.0.1").getIsSnmpPrimary());
        Assert.assertEquals((Object)PrimaryType.NOT_ELIGIBLE, (Object)node1.getIpInterfaceByIpAddress("172.17.0.1").getIsSnmpPrimary());
        Assert.assertEquals((Object)PrimaryType.PRIMARY, (Object)node1.getIpInterfaceByIpAddress("192.168.0.10").getIsSnmpPrimary());
        Assert.assertEquals((Object)"custom-location", (Object)node1.getLocation().getLocationName());
        node2 = (OnmsNode)p.apply((Object)node2);
        Assert.assertEquals((Object)PrimaryType.PRIMARY, (Object)node2.getIpInterfaceByIpAddress("172.16.0.1").getIsSnmpPrimary());
        Assert.assertEquals((Object)PrimaryType.SECONDARY, (Object)node2.getIpInterfaceByIpAddress("172.17.0.1").getIsSnmpPrimary());
        Assert.assertEquals((Object)PrimaryType.NOT_ELIGIBLE, (Object)node2.getIpInterfaceByIpAddress("192.168.0.20").getIsSnmpPrimary());
        Assert.assertEquals((Object)"Default", (Object)node2.getLocation().getLocationName());
    }

    @Test
    public void testScriptCompilation() throws Exception {
        OnmsNode node1 = new OnmsNode();
        node1.setNodeId("1");
        node1.setLocation(new OnmsMonitoringLocation("Default", ""));
        OnmsIpInterface iface1_1 = new OnmsIpInterface();
        iface1_1.setIpAddress(InetAddress.getByName("172.16.0.1"));
        iface1_1.setIsSnmpPrimary(PrimaryType.PRIMARY);
        OnmsIpInterface iface1_2 = new OnmsIpInterface();
        iface1_2.setIpAddress(InetAddress.getByName("172.17.0.1"));
        iface1_2.setIsSnmpPrimary(PrimaryType.SECONDARY);
        OnmsIpInterface iface1_3 = new OnmsIpInterface();
        iface1_3.setIpAddress(InetAddress.getByName("192.168.0.10"));
        iface1_3.setIsSnmpPrimary(PrimaryType.NOT_ELIGIBLE);
        node1.addIpInterface(iface1_1);
        node1.addIpInterface(iface1_2);
        node1.addIpInterface(iface1_3);
        node1.setForeignSource("nodes");
        node1.setForeignId("1");
        node1.setLabel("Node-1-Foo");
        File scriptFile = File.createTempFile("foobar", ".groovy");
        ScriptPolicy p = new ScriptPolicy(Paths.get("src", "test", "resources").toAbsolutePath());
        p.setLabel("~.*");
        p.setMatchBehavior("ALL_PARAMETERS");
        p.setScript(scriptFile.getAbsolutePath());
        this.createScriptFile(scriptFile, 1, false);
        node1 = (OnmsNode)p.apply((Object)node1);
        Assert.assertEquals((Object)"Test #1", (Object)node1.getLabel());
        Thread.sleep(500L);
        this.createScriptFile(scriptFile, 2, true);
        node1 = (OnmsNode)p.apply((Object)node1);
        Assert.assertEquals((Object)"Test #1", (Object)node1.getLabel());
        Thread.sleep(500L);
        this.createScriptFile(scriptFile, 3, false);
        node1 = (OnmsNode)p.apply((Object)node1);
        Assert.assertEquals((Object)"Test #3", (Object)node1.getLabel());
    }

    private void createScriptFile(File file, int run, boolean preserveLastModified) throws IOException {
        long lastModified = file.lastModified();
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(file));){
            printWriter.println("node.setLabel(\"Test #" + run + "\")");
            printWriter.println("return node");
        }
        if (preserveLastModified) {
            file.setLastModified(lastModified);
        }
    }
}

