/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Script Policy")
public class ScriptPolicy
extends BasePolicy<OnmsNode>
implements NodePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptPolicy.class);
    private Path m_scriptPath;
    private final ScriptEngineManager m_scriptManager = new ScriptEngineManager();
    private long m_lastCompiled = -1L;
    private String m_script;
    private CompiledScript m_compiledScript;

    public ScriptPolicy() {
        this(Paths.get(System.getProperty("opennms.home"), "etc", "script-policies"));
    }

    public ScriptPolicy(Path scriptPath) {
        this.m_scriptPath = scriptPath;
    }

    private CompiledScript compileScript(String script) throws IOException, ScriptException {
        if (script == null) {
            throw new IllegalArgumentException("Script must not be null");
        }
        File scriptFile = this.m_scriptPath.resolve(script).toFile();
        if (!scriptFile.canRead()) {
            throw new IllegalStateException("Cannot read script at '" + scriptFile + "'.");
        }
        if (scriptFile.lastModified() > this.m_lastCompiled) {
            String fileExtension = Files.getFileExtension((String)scriptFile.getAbsolutePath());
            ScriptEngine engine = this.m_scriptManager.getEngineByExtension(fileExtension);
            if (engine == null) {
                throw new IllegalStateException("No engine found for file extension: " + fileExtension);
            }
            if (!(engine instanceof Compilable)) {
                throw new IllegalStateException("Only engines that can compile scripts are supported.");
            }
            Compilable compilable = (Compilable)((Object)engine);
            try (FileReader reader = new FileReader(scriptFile);){
                this.m_compiledScript = compilable.compile(reader);
            }
            this.m_lastCompiled = scriptFile.lastModified();
        }
        return this.m_compiledScript;
    }

    public OnmsNode act(OnmsNode node) {
        try {
            CompiledScript compiledScript = this.compileScript(this.getScript());
            if (compiledScript != null) {
                SimpleBindings globals = new SimpleBindings();
                globals.put("node", (Object)node);
                globals.put("LOG", (Object)LOG);
                return (OnmsNode)compiledScript.eval(globals);
            }
            LOG.warn("No compiled script available for execution.");
        }
        catch (Exception ex) {
            LOG.warn("Error applying ScriptPolicy.", (Throwable)ex);
        }
        return node;
    }

    @Require(value={})
    public String getScript() {
        return this.m_script;
    }

    public void setScript(String script) {
        this.m_script = script;
    }

    public String getType() {
        return this.getCriteria("type");
    }

    public void setType(String type) {
        this.putCriteria("type", type);
    }

    public String getSysObjectId() {
        return this.getCriteria("sysObjectId");
    }

    public void setSysObjectId(String sysObjectId) {
        this.putCriteria("sysObjectId", sysObjectId);
    }

    public String getSysName() {
        return this.getCriteria("sysName");
    }

    public void setSysName(String sysName) {
        this.putCriteria("sysName", sysName);
    }

    public String getSysDescription() {
        return this.getCriteria("sysDescription");
    }

    public void setSysDescription(String sysDescription) {
        this.putCriteria("sysDescription", sysDescription);
    }

    public String getSysLocation() {
        return this.getCriteria("sysLocation");
    }

    public void setSysLocation(String sysLocation) {
        this.putCriteria("sysLocation", sysLocation);
    }

    public String getSysContact() {
        return this.getCriteria("sysContact");
    }

    public void setSysContact(String sysContact) {
        this.putCriteria("sysContact", sysContact);
    }

    public String getLabel() {
        return this.getCriteria("label");
    }

    public void setLabel(String label) {
        this.putCriteria("label", label);
    }

    public String getLabelSource() {
        return this.getCriteria("labelSource");
    }

    public void setLabelSource(String labelSource) {
        this.putCriteria("labelSource", labelSource);
    }

    public String getNetBiosName() {
        return this.getCriteria("netBiosName");
    }

    public void setNetBiosName(String netBiosName) {
        this.putCriteria("netBiosName", netBiosName);
    }

    public String getNetBiosDomain() {
        return this.getCriteria("netBiosDomain");
    }

    public void setNetBiosDomain(String netBiosDomain) {
        this.putCriteria("netBiosDomain", netBiosDomain);
    }

    public String getOperatingSystem() {
        return this.getCriteria("operatingSystem");
    }

    public void setOperatingSystem(String operatingSystem) {
        this.putCriteria("operatingSystem", operatingSystem);
    }

    public String getForeignId() {
        return this.getCriteria("foreignId");
    }

    public void setForeignId(String foreignId) {
        this.putCriteria("foreignId", foreignId);
    }

    public String getForeignSource() {
        return this.getCriteria("foreignSource");
    }

    public void setForeignSource(String foreignSource) {
        this.putCriteria("foreignSource", foreignSource);
    }
}

