/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.provision.persist.OnmsServiceCategoryRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;

public class OnmsMonitoredServiceRequisition {
    private RequisitionMonitoredService m_svc;
    private final List<OnmsServiceCategoryRequisition> m_categoryReqs;

    public OnmsMonitoredServiceRequisition(RequisitionMonitoredService svc) {
        this.m_svc = svc;
        this.m_categoryReqs = this.constructCategoryReqs();
    }

    private List<OnmsServiceCategoryRequisition> constructCategoryReqs() {
        ArrayList<OnmsServiceCategoryRequisition> reqs = new ArrayList<OnmsServiceCategoryRequisition>(this.m_svc.getCategories().size());
        for (RequisitionCategory cat : this.m_svc.getCategories()) {
            reqs.add(new OnmsServiceCategoryRequisition(cat));
        }
        return reqs;
    }

    RequisitionMonitoredService getSvc() {
        return this.m_svc;
    }

    public void visit(RequisitionVisitor visitor) {
        visitor.visitMonitoredService(this);
        for (OnmsServiceCategoryRequisition cat : this.m_categoryReqs) {
            cat.visit(visitor);
        }
        visitor.completeMonitoredService(this);
    }

    public String getServiceName() {
        return this.m_svc.getServiceName();
    }
}

