/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

public class RequisitionFileUtilsTest {
    private FilesystemForeignSourceRepository m_repository;
    private Path m_requisitionDirectory;
    private String m_importDirectory;
    private String m_foreignSourceDirectory;

    @Before
    public void createTestRepository() throws Exception {
        this.m_requisitionDirectory = Files.createTempDirectory("RequisitionFileUtilsTest", new FileAttribute[0]);
        if (this.m_requisitionDirectory.toFile().exists()) {
            FileUtils.deleteDirectory((File)this.m_requisitionDirectory.toFile());
        }
        FilesystemForeignSourceRepository fsr = new FilesystemForeignSourceRepository();
        this.m_importDirectory = new File(this.m_requisitionDirectory.toFile(), "imports").getPath();
        this.m_foreignSourceDirectory = new File(this.m_requisitionDirectory.toFile(), "foreign-sources").getPath();
        fsr.setRequisitionPath(this.m_importDirectory);
        fsr.setForeignSourcePath(this.m_foreignSourceDirectory);
        fsr.afterPropertiesSet();
        fsr.save(new Requisition("test"));
        this.m_repository = fsr;
    }

    @After
    public void destroyTestRepository() throws Exception {
        FileUtils.deleteDirectory((File)this.m_requisitionDirectory.toFile());
    }

    @Test
    public void testCreateTemporaryRequisition() throws Exception {
        File file = RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getPath().contains(this.m_importDirectory + File.separator + "test"));
        Assert.assertTrue((boolean)file.getParentFile().getName().equals("imports"));
        Assert.assertTrue((boolean)file.getName().matches("test\\.xml\\.\\d+"));
        List snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertNotNull((Object)snapshots);
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Thread.sleep(1L);
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Assert.assertEquals((long)2L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test").size());
        this.m_repository.save(new Requisition("test2"));
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test2", (Date)new Date());
        Assert.assertEquals((long)1L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test2").size());
        Assert.assertEquals((long)2L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test").size());
    }

    @Test
    public void testDeleteSnapshots() throws Exception {
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Thread.sleep(1L);
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Thread.sleep(1L);
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        List snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertNotNull((Object)snapshots);
        Assert.assertEquals((long)3L, (long)snapshots.size());
        RequisitionFileUtils.deleteAllSnapshots((ForeignSourceRepository)this.m_repository);
        snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertEquals((long)0L, (long)snapshots.size());
    }
}

