/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.opennms.netmgt.provision.persist.StringIntervalAdapter;

public class StringIntervalPropertyEditor
extends PropertyEditorSupport
implements PropertyEditor {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if ("0".equals(text)) {
            this.setValue(Duration.ZERO);
        } else {
            this.setValue(StringIntervalAdapter.DEFAULT_PERIOD_FORMATTER.parsePeriod(text).toStandardDuration());
        }
    }

    @Override
    public String getAsText() {
        Duration value = (Duration)this.getValue();
        if (value.equals((Object)Duration.ZERO)) {
            return "0";
        }
        Period p = value.toPeriod().normalizedStandard();
        return StringIntervalAdapter.DEFAULT_PERIOD_FORMATTER.print((ReadablePeriod)p);
    }
}

