/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FusedForeignSourceRepository
extends AbstractForeignSourceRepository
implements ForeignSourceRepository,
InitializingBean {
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    private ForeignSourceRepository m_deployedForeignSourceRepository;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_pendingForeignSourceRepository, (String)"Pending foreign source repository must not be null.");
        Assert.notNull((Object)this.m_deployedForeignSourceRepository, (String)"Deployed foreign source repository must not be null.");
    }

    public ForeignSourceRepository getPendingForeignSourceRepository() {
        return this.m_pendingForeignSourceRepository;
    }

    public void setPendingForeignSourceRepository(ForeignSourceRepository fsr) {
        this.m_pendingForeignSourceRepository = fsr;
    }

    public ForeignSourceRepository getDeployedForeignSourceRepository() {
        return this.m_deployedForeignSourceRepository;
    }

    public void setDeployedForeignSourceRepository(ForeignSourceRepository fsr) {
        this.m_deployedForeignSourceRepository = fsr;
    }

    @Override
    public synchronized Set<String> getActiveForeignSourceNames() {
        HashSet<String> fsNames = new HashSet<String>(this.m_pendingForeignSourceRepository.getActiveForeignSourceNames());
        fsNames.addAll(this.m_deployedForeignSourceRepository.getActiveForeignSourceNames());
        return fsNames;
    }

    @Override
    public synchronized Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        Requisition requisition = this.m_deployedForeignSourceRepository.importResourceRequisition(resource);
        String foreignSource = requisition.getForeignSource();
        this.cleanUpDeployedForeignSources(foreignSource);
        this.cleanUpSnapshots(requisition);
        return requisition;
    }

    private synchronized void cleanUpDeployedForeignSources(String foreignSourceName) {
        ForeignSource deployed = this.m_deployedForeignSourceRepository.getForeignSource(foreignSourceName);
        ForeignSource pending = this.m_pendingForeignSourceRepository.getForeignSource(foreignSourceName);
        if (pending.isDefault()) {
            this.m_pendingForeignSourceRepository.delete(pending);
        } else if (deployed.isDefault()) {
            this.m_deployedForeignSourceRepository.save(pending);
        } else {
            Date pendingDate = pending.getDateStampAsDate();
            Date deployedDate = deployed.getDateStampAsDate();
            if (!deployedDate.after(pendingDate)) {
                this.m_deployedForeignSourceRepository.save(pending);
            }
        }
        this.m_pendingForeignSourceRepository.delete(pending);
    }

    @Override
    public synchronized void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(foreignSource);
        this.m_deployedForeignSourceRepository.delete(foreignSource);
    }

    @Override
    public synchronized void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.delete(requisition);
        this.m_deployedForeignSourceRepository.delete(requisition);
    }

    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSource(foreignSourceName);
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSourceCount();
    }

    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getForeignSources();
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisition(foreignSourceName);
    }

    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisition(foreignSource);
    }

    @Override
    public Date getRequisitionDate(String foreignSource) {
        return this.m_deployedForeignSourceRepository.getRequisitionDate(foreignSource);
    }

    @Override
    public URL getRequisitionURL(String foreignSource) {
        return this.m_deployedForeignSourceRepository.getRequisitionURL(foreignSource);
    }

    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        return this.m_deployedForeignSourceRepository.getRequisitions();
    }

    @Override
    public synchronized void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_deployedForeignSourceRepository.validate(foreignSource);
        this.m_pendingForeignSourceRepository.delete(foreignSource);
        this.m_deployedForeignSourceRepository.save(foreignSource);
    }

    @Override
    public synchronized void save(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_deployedForeignSourceRepository.validate(requisition);
        this.m_deployedForeignSourceRepository.save(requisition);
        this.cleanUpSnapshots(requisition);
    }

    private void cleanUpSnapshots(Requisition requisition) {
        String foreignSource = requisition.getForeignSource();
        Date pendingDate = this.m_pendingForeignSourceRepository.getRequisitionDate(foreignSource);
        List<File> pendingSnapshots = RequisitionFileUtils.findSnapshots(this.m_pendingForeignSourceRepository, foreignSource);
        if (pendingDate != null) {
            boolean deletePendingRequisition = true;
            if (pendingSnapshots.size() > 0) {
                for (File pendingSnapshotFile : pendingSnapshots) {
                    if (!this.isNewer(pendingSnapshotFile, pendingDate)) continue;
                    deletePendingRequisition = false;
                    break;
                }
            }
            if (deletePendingRequisition) {
                this.m_pendingForeignSourceRepository.delete(requisition);
            }
        }
        RequisitionFileUtils.deleteResourceIfSnapshot(requisition);
        Date deployedDate = this.m_deployedForeignSourceRepository.getRequisitionDate(foreignSource);
        if (deployedDate != null) {
            RequisitionFileUtils.deleteSnapshotsOlderThan(this.getPendingForeignSourceRepository(), foreignSource, deployedDate);
        }
    }

    private boolean isNewer(File snap, Date date) {
        return RequisitionFileUtils.isNewer(snap, date);
    }

    @Override
    public void flush() throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.flush();
        this.m_deployedForeignSourceRepository.flush();
    }

    @Override
    public void clear() throws ForeignSourceRepositoryException {
        this.m_pendingForeignSourceRepository.clear();
        this.m_deployedForeignSourceRepository.clear();
        super.clear();
    }
}

