/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryTestCase;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.TestVisitor;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FastFilesystemForeignSourceRepositoryTest
extends ForeignSourceRepositoryTestCase {
    private String m_defaultForeignSourceName;
    private File m_requisitionDirectory;
    @Autowired
    @Qualifier(value="fastFilePending")
    private ForeignSourceRepository m_foreignSourceRepository;

    @Before
    public void setUp() throws Exception {
        this.m_requisitionDirectory = new File("target/opennms-home/etc/imports/pending");
        this.m_requisitionDirectory.mkdirs();
        this.m_defaultForeignSourceName = "imported:";
        this.m_foreignSourceRepository.clear();
        this.m_foreignSourceRepository.flush();
        FileUtils.copyFile((File)new File("src/test/resources/requisition-test.xml"), (File)this.getRequisitionFile());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.m_requisitionDirectory);
    }

    private File getRequisitionFile() {
        return new File(this.m_requisitionDirectory, this.m_defaultForeignSourceName + ".xml");
    }

    private Requisition createRequisition() throws Exception {
        FileSystemResource resource = new FileSystemResource(this.getRequisitionFile());
        Requisition r = this.m_foreignSourceRepository.importResourceRequisition((Resource)resource);
        this.m_foreignSourceRepository.save(r);
        this.m_foreignSourceRepository.flush();
        Thread.sleep(2000L);
        return r;
    }

    private ForeignSource createForeignSource(String foreignSource) throws Exception {
        ForeignSource fs = new ForeignSource(foreignSource);
        fs.addDetector(new PluginConfig("HTTP", "org.opennms.netmgt.provision.detector.simple.HttpDetector"));
        fs.addPolicy(new PluginConfig("all-ipinterfaces", "org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy"));
        this.m_foreignSourceRepository.save(fs);
        this.m_foreignSourceRepository.flush();
        Thread.sleep(2000L);
        return fs;
    }

    private void modifyRequisition() throws Exception {
        Requisition r = (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)this.getRequisitionFile());
        Assert.assertNotNull((Object)r);
        r.getNode("4243").setNodeLabel("apknd_2");
        RequisitionNode n = new RequisitionNode();
        n.setForeignId("R2D2");
        n.setNodeLabel("utility-robot");
        n.getCategories().add(new RequisitionCategory("StarWars"));
        n.getCategories().add(new RequisitionCategory("Rebels"));
        r.getNodes().add(n);
        JaxbUtils.marshal((Object)r, (Writer)new FileWriter(this.getRequisitionFile()));
        Thread.sleep(2000L);
    }

    private void deleteRequisition() throws Exception {
        Assert.assertTrue((boolean)this.getRequisitionFile().delete());
        Thread.sleep(2000L);
    }

    @Test
    public void testRequisition() throws Exception {
        this.createRequisition();
        Requisition r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        TestVisitor v = new TestVisitor();
        r.visit((RequisitionVisitor)v);
        Assert.assertEquals((String)"number of nodes visited", (long)2L, (long)v.getNodeReqs().size());
        Assert.assertEquals((String)"node name matches", (Object)"apknd", (Object)v.getNodeReqs().get(0).getNodeLabel());
        this.modifyRequisition();
        r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        v = new TestVisitor();
        r.visit((RequisitionVisitor)v);
        Assert.assertEquals((String)"number of nodes visited", (long)3L, (long)v.getNodeReqs().size());
        Assert.assertEquals((String)"node name matches", (Object)"apknd_2", (Object)v.getNodeReqs().get(0).getNodeLabel());
        Assert.assertEquals((String)"node name matches", (Object)"wan0", (Object)v.getNodeReqs().get(1).getNodeLabel());
        Assert.assertEquals((String)"node name matches", (Object)"utility-robot", (Object)v.getNodeReqs().get(2).getNodeLabel());
        this.deleteRequisition();
        r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        Assert.assertNull((Object)r);
    }

    @Test
    public void testForeignSource() throws Exception {
        this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        Set foreignSources = this.m_foreignSourceRepository.getForeignSources();
        Assert.assertEquals((String)"number of foreign sources must be 1", (long)1L, (long)foreignSources.size());
        Assert.assertEquals((String)"getAll() foreign source name must match", (Object)this.m_defaultForeignSourceName, (Object)((ForeignSource)foreignSources.iterator().next()).getName());
        ForeignSource newForeignSource = this.m_foreignSourceRepository.getForeignSource(this.m_defaultForeignSourceName);
        Assert.assertEquals((Object)foreignSource.getName(), (Object)newForeignSource.getName());
        Assert.assertEquals((Object)foreignSource.getDateStampAsDate(), (Object)newForeignSource.getDateStampAsDate());
        Assert.assertEquals((Object)foreignSource.getDetectorNames(), (Object)newForeignSource.getDetectorNames());
        Assert.assertEquals((Object)foreignSource.getScanInterval(), (Object)newForeignSource.getScanInterval());
    }

    @Test
    public void testGetRequisition() throws Exception {
        Requisition requisition = this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        this.assertRequisitionsMatch("requisitions must match", this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName), this.m_foreignSourceRepository.getRequisition(foreignSource));
        this.assertRequisitionsMatch("foreign source is the expected one", requisition, this.m_foreignSourceRepository.getRequisition(foreignSource));
    }

    @Test
    public void testDefaultForeignSource() throws Exception {
        this.createRequisition();
        List<String> detectorList = Arrays.asList("DNS", "FTP", "HTTP", "HTTPS", "ICMP", "IMAP", "LDAP", "NRPE", "POP3", "SMTP", "SNMP", "SSH");
        String uuid = UUID.randomUUID().toString();
        ForeignSource defaultForeignSource = this.m_foreignSourceRepository.getForeignSource(uuid);
        Assert.assertEquals((String)"name must match requested foreign source repository name", (Object)uuid, (Object)defaultForeignSource.getName());
        Assert.assertEquals((String)"scan-interval must be 1 day", (long)86400000L, (long)defaultForeignSource.getScanInterval().getMillis());
        Assert.assertEquals((String)"foreign source must have no default policies", (long)0L, (long)defaultForeignSource.getPolicies().size());
        ArrayList<String> fsNames = new ArrayList<String>();
        for (PluginConfig config : defaultForeignSource.getDetectors()) {
            fsNames.add(config.getName());
        }
        Assert.assertEquals((String)"detector list must match expected defaults", detectorList, fsNames);
        Assert.assertTrue((String)"foreign source must be tagged as default", (boolean)defaultForeignSource.isDefault());
    }
}

