/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.FasterFilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.FileSystemBuilder;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/opennms/netmgt/provision/persist/emptyContext.xml"})
public class FasterFilesystemForeignSourceRepositoryTest {
    @Test
    public void testActiveForeignSourceNames() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testActiveForeignSourceNames");
        File fsDir = bldr.dir("foreignSource").file("test.xml").file("noreq.xml").pop();
        File reqDir = bldr.dir("requisitions").file("test.xml").file("pending.xml").pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        Assert.assertEquals(FasterFilesystemForeignSourceRepositoryTest.set("test", "pending", "noreq"), (Object)repo.getActiveForeignSourceNames());
    }

    @Test
    public void testGetForeignSourceCount() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testGetForeignSourceCount");
        File fsDir = bldr.dir("foreignSource").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.fs("test")).file("noreq.xml", FasterFilesystemForeignSourceRepositoryTest.fs("noreq")).file("another.xml", FasterFilesystemForeignSourceRepositoryTest.fs("another")).pop();
        File reqDir = bldr.dir("requisitions").file("test.xml").file("pending.xml").pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        Assert.assertEquals((long)3L, (long)repo.getForeignSourceCount());
    }

    @Test
    public void testGetForeignSources() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testGetForeignSources");
        File fsDir = bldr.dir("foreignSource").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.fs("test")).pop();
        File reqDir = bldr.dir("requisitions").file("test.xml").file("pending.xml").pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        Set foreignSources = repo.getForeignSources();
        Assert.assertEquals((long)1L, (long)foreignSources.size());
        ForeignSource testFS = (ForeignSource)foreignSources.iterator().next();
        Assert.assertEquals((Object)"test", (Object)testFS.getName());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)testFS.getScanInterval());
    }

    @Test
    public void testGetForeignSource() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testGetForeignSource");
        File fsDir = bldr.dir("foreignSource").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.fs("test")).file("noreq.xml", FasterFilesystemForeignSourceRepositoryTest.fs("noreq")).pop();
        File reqDir = bldr.dir("requisitions").file("test.xml").file("pending.xml").pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        ForeignSource testFS = repo.getForeignSource("test");
        Assert.assertEquals((Object)"test", (Object)testFS.getName());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)testFS.getScanInterval());
    }

    @Test
    public void testGetRequisition() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testGetForeignSource");
        File fsDir = bldr.dir("foreignSource").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.fs("test")).file("noreq.xml", FasterFilesystemForeignSourceRepositoryTest.fs("noreq")).pop();
        File reqDir = bldr.dir("requisitions").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.req("test")).file("pending.xml", FasterFilesystemForeignSourceRepositoryTest.req("pending")).pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        Requisition testReq = repo.getRequisition("test");
        Assert.assertEquals((Object)"test", (Object)testReq.getForeignSource());
        RequisitionNode node = testReq.getNode("1234");
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)"node1", (Object)node.getNodeLabel());
    }

    @Test
    @JUnitHttpServer(port=9162)
    public void testImportHttpSource() throws Exception {
        FileSystemBuilder bldr = new FileSystemBuilder("target", "testGetForeignSource");
        File fsDir = bldr.dir("foreignSource").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.fs("test")).file("noreq.xml", FasterFilesystemForeignSourceRepositoryTest.fs("noreq")).pop();
        File reqDir = bldr.dir("requisitions").file("test.xml", FasterFilesystemForeignSourceRepositoryTest.req("test")).file("pending.xml", FasterFilesystemForeignSourceRepositoryTest.req("pending")).pop();
        FasterFilesystemForeignSourceRepository repo = FasterFilesystemForeignSourceRepositoryTest.repo(fsDir, reqDir);
        UrlResource resource = new UrlResource("http://localhost:9162/requisition-test.xml");
        Requisition req = repo.importResourceRequisition((Resource)resource);
        Assert.assertNotNull((Object)req);
        System.err.println(JaxbUtils.marshal((Object)req));
        Assert.assertNotNull((Object)req.getNode("4243"));
        Assert.assertNotNull((Object)req.getNode("4244"));
    }

    private static FasterFilesystemForeignSourceRepository repo(File foreignSourceDir, File requisitionDir) throws Exception {
        FasterFilesystemForeignSourceRepository repo = new FasterFilesystemForeignSourceRepository();
        repo.setForeignSourcePath(foreignSourceDir.getAbsolutePath());
        repo.setRequisitionPath(requisitionDir.getAbsolutePath());
        repo.afterPropertiesSet();
        return repo;
    }

    private static Set<String> set(String ... items) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, items);
        return set;
    }

    private static String fs(String name) {
        String template = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<foreign-source date-stamp=\"2012-12-17T13:59:04.299-05:00\" name=\"_TEMPLATE_\" xmlns=\"http://xmlns.opennms.org/xsd/config/foreign-source\">\n    <scan-interval>1d</scan-interval>\n    <detectors>\n        <detector class=\"org.opennms.netmgt.provision.detector.icmp.IcmpDetector\" name=\"ICMP\"/>\n        <detector class=\"org.opennms.netmgt.provision.detector.snmp.SnmpDetector\" name=\"SNMP\"/>\n    </detectors>\n    <policies/>\n</foreign-source>";
        return template.replaceAll("_TEMPLATE_", name);
    }

    private static String req(String name) {
        String template = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<model-import last-import=\"2012-12-17T14:00:08.997-05:00\" foreign-source=\"_TEMPLATE_\" date-stamp=\"2012-12-17T14:00:08.757-05:00\" xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\">\n    <node node-label=\"node1\" foreign-id=\"1234\" building=\"_TEMPLATE_\">\n        <interface snmp-primary=\"P\" status=\"1\" ip-addr=\"127.0.0.1\" descr=\"\"/>\n    </node>\n</model-import>\n";
        return template.replaceAll("_TEMPLATE_", name);
    }
}

