/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CachingForeignSourceRepository
extends AbstractForeignSourceRepository
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CachingForeignSourceRepository.class);
    private final ReentrantReadWriteLock m_globalLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock m_readLock = this.m_globalLock.readLock();
    private final ReentrantReadWriteLock.WriteLock m_writeLock = this.m_globalLock.writeLock();
    private ForeignSourceRepository m_foreignSourceRepository;
    private Set<String> m_dirtyForeignSources = new HashSet<String>();
    private Set<String> m_dirtyRequisitions = new HashSet<String>();
    private Set<String> m_foreignSourceNames;
    private Map<String, ForeignSource> m_foreignSources;
    private Map<String, Requisition> m_requisitions;
    private ForeignSource m_defaultForeignSource;
    private ScheduledExecutorService m_executor;

    public CachingForeignSourceRepository() {
        long refreshInterval = Long.getLong("org.opennms.netmgt.provision.persist.cacheRefreshInterval", 300000L);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.m_executor = executor;
        this.m_executor.scheduleAtFixedRate(this.getRefreshRunnable(), refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
    }

    protected void writeUnlock() {
        if (this.m_globalLock.getWriteHoldCount() > 0) {
            this.m_writeLock.unlock();
        }
    }

    protected void writeLock() {
        if (this.m_globalLock.getWriteHoldCount() == 0) {
            while (this.m_globalLock.getReadHoldCount() > 0) {
                this.m_readLock.unlock();
            }
            this.m_writeLock.lock();
        }
    }

    protected void readUnlock() {
        if (this.m_globalLock.getReadHoldCount() > 0) {
            this.m_readLock.unlock();
        }
    }

    protected void readLock() {
        this.m_readLock.lock();
    }

    protected void cleanCache() {
        this.getRefreshRunnable().run();
    }

    protected Runnable getRefreshRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CachingForeignSourceRepository.this.writeLock();
                try {
                    Comparable<ForeignSource> current;
                    CachingForeignSourceRepository.this.m_foreignSourceNames = null;
                    if (CachingForeignSourceRepository.this.m_dirtyForeignSources.size() > 0) {
                        for (String dirtyForeignSource : CachingForeignSourceRepository.this.m_dirtyForeignSources) {
                            ForeignSource fs = (ForeignSource)CachingForeignSourceRepository.this.getForeignSourceMap().get(dirtyForeignSource);
                            try {
                                if (fs == null) {
                                    current = CachingForeignSourceRepository.this.m_foreignSourceRepository.getForeignSource(dirtyForeignSource);
                                    if (current == null) continue;
                                    CachingForeignSourceRepository.this.m_foreignSourceRepository.delete((ForeignSource)current);
                                    continue;
                                }
                                CachingForeignSourceRepository.this.m_foreignSourceRepository.save(fs);
                            }
                            catch (ForeignSourceRepositoryException e) {
                                LOG.error("Failed to persist foreign source {}", (Object)dirtyForeignSource, (Object)e);
                            }
                        }
                        CachingForeignSourceRepository.this.m_dirtyForeignSources.clear();
                    }
                    CachingForeignSourceRepository.this.m_foreignSources = null;
                    if (CachingForeignSourceRepository.this.m_dirtyRequisitions.size() > 0) {
                        for (String dirtyRequisition : CachingForeignSourceRepository.this.m_dirtyRequisitions) {
                            Requisition r = (Requisition)CachingForeignSourceRepository.this.getRequisitionMap().get(dirtyRequisition);
                            try {
                                if (r == null) {
                                    current = CachingForeignSourceRepository.this.m_foreignSourceRepository.getRequisition(dirtyRequisition);
                                    if (current == null) continue;
                                    CachingForeignSourceRepository.this.m_foreignSourceRepository.delete(r);
                                    continue;
                                }
                                CachingForeignSourceRepository.this.m_foreignSourceRepository.save(r);
                            }
                            catch (ForeignSourceRepositoryException e) {
                                LOG.error("Failed to persist requisition {}", (Object)dirtyRequisition, (Object)e);
                            }
                        }
                        CachingForeignSourceRepository.this.m_dirtyForeignSources.clear();
                    }
                    CachingForeignSourceRepository.this.m_requisitions = null;
                }
                finally {
                    CachingForeignSourceRepository.this.writeUnlock();
                }
            }
        };
    }

    public ForeignSourceRepository getForeignSourceRepository() {
        return this.m_foreignSourceRepository;
    }

    public void setForeignSourceRepository(ForeignSourceRepository fsr) {
        this.m_foreignSourceRepository = fsr;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_foreignSourceRepository);
    }

    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.readLock();
        try {
            if (this.m_foreignSourceNames == null) {
                this.m_foreignSourceNames = this.m_foreignSourceRepository.getActiveForeignSourceNames();
            }
            Set<String> set = this.m_foreignSourceNames;
            return set;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            int n = this.getForeignSources().size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ForeignSource> getForeignSourceMap() {
        this.readLock();
        try {
            if (this.m_foreignSources == null) {
                this.writeLock();
                try {
                    TreeMap<String, ForeignSource> fses = new TreeMap<String, ForeignSource>();
                    for (ForeignSource fs : this.m_foreignSourceRepository.getForeignSources()) {
                        fses.put(fs.getName(), fs);
                    }
                    this.m_foreignSources = fses;
                }
                finally {
                    this.readLock();
                    this.writeUnlock();
                }
            }
            Map<String, ForeignSource> map = this.m_foreignSources;
            return map;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            TreeSet<ForeignSource> treeSet = new TreeSet<ForeignSource>(this.getForeignSourceMap().values());
            return treeSet;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            ForeignSource fs = this.getForeignSourceMap().get(foreignSourceName);
            if (fs == null) {
                fs = this.getDefaultForeignSource();
                fs.setName(foreignSourceName);
            }
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            this.validate(foreignSource);
            Map<String, ForeignSource> fses = this.getForeignSourceMap();
            fses.put(foreignSource.getName(), foreignSource);
            this.m_dirtyForeignSources.add(foreignSource.getName());
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            this.getForeignSourceMap().remove(foreignSource.getName());
            this.m_dirtyForeignSources.add(foreignSource.getName());
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public ForeignSource getDefaultForeignSource() throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            if (this.m_defaultForeignSource == null) {
                this.writeLock();
                try {
                    this.m_defaultForeignSource = this.m_foreignSourceRepository.getDefaultForeignSource();
                }
                finally {
                    this.readLock();
                    this.readUnlock();
                }
            }
            ForeignSource foreignSource = this.m_defaultForeignSource;
            return foreignSource;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void putDefaultForeignSource(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.writeLock();
        try {
            this.cleanCache();
            this.m_foreignSourceRepository.putDefaultForeignSource(foreignSource);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void resetDefaultForeignSource() throws ForeignSourceRepositoryException {
        this.writeLock();
        try {
            this.cleanCache();
            this.m_foreignSourceRepository.resetDefaultForeignSource();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Requisition> getRequisitionMap() {
        this.readLock();
        try {
            if (this.m_requisitions == null) {
                this.writeLock();
                try {
                    TreeMap<String, Requisition> requisitions = new TreeMap<String, Requisition>();
                    for (Requisition requisition : this.m_foreignSourceRepository.getRequisitions()) {
                        requisitions.put(requisition.getForeignSource(), requisition);
                    }
                    this.m_requisitions = requisitions;
                }
                finally {
                    this.readLock();
                    this.writeUnlock();
                }
            }
            Map<String, Requisition> map = this.m_requisitions;
            return map;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        this.writeLock();
        try {
            Requisition requisition = super.importResourceRequisition(resource);
            return requisition;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            TreeSet<Requisition> treeSet = new TreeSet<Requisition>(this.getRequisitionMap().values());
            return treeSet;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            Requisition requisition = this.getRequisitionMap().get(foreignSourceName);
            return requisition;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            Requisition requisition = this.getRequisitionMap().get(foreignSource.getName());
            return requisition;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Date getRequisitionDate(String foreignSource) {
        return this.m_foreignSourceRepository.getRequisitionDate(foreignSource);
    }

    @Override
    public URL getRequisitionURL(String foreignSource) {
        return this.m_foreignSourceRepository.getRequisitionURL(foreignSource);
    }

    @Override
    public void save(Requisition requisition) throws ForeignSourceRepositoryException {
        this.writeLock();
        try {
            this.validate(requisition);
            this.getRequisitionMap().put(requisition.getForeignSource(), requisition);
            this.m_dirtyRequisitions.add(requisition.getForeignSource());
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        this.writeLock();
        try {
            this.getRequisitionMap().remove(requisition.getForeignSource());
            this.m_dirtyRequisitions.add(requisition.getForeignSource());
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnmsNodeRequisition getNodeRequisition(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        this.readLock();
        try {
            Requisition requisition = this.getRequisitionMap().get(foreignSource);
            OnmsNodeRequisition onmsNodeRequisition = requisition == null ? null : requisition.getNodeRequistion(foreignId);
            return onmsNodeRequisition;
        }
        finally {
            this.readUnlock();
        }
    }

    protected void finalize() throws Throwable {
        this.m_executor.shutdown();
        this.cleanCache();
        super.finalize();
    }

    @Override
    public void flush() throws ForeignSourceRepositoryException {
        this.getRefreshRunnable().run();
    }

    @Override
    public void clear() throws ForeignSourceRepositoryException {
        this.cleanCache();
        this.writeLock();
        try {
            this.m_foreignSourceRepository.clear();
        }
        finally {
            this.writeUnlock();
        }
    }
}

