/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.MockForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSourceCollection;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.test.FileAnticipator;
import org.xml.sax.SAXException;

public class PersistenceSerializationTest {
    private ForeignSourceCollection fsw;
    private AbstractForeignSourceRepository fsr;
    private Marshaller m;
    private JAXBContext c;
    private ForeignSource fs;
    private FileAnticipator fa;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.fa = new FileAnticipator();
        this.fsr = new MockForeignSourceRepository();
        this.fsr.save(new ForeignSource("cheese"));
        this.fsr.flush();
        this.fs = this.fsr.getForeignSource("cheese");
        XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar("2009-02-25T12:45:38.800-05:00");
        this.fs.setDateStamp(cal);
        ArrayList<PluginConfig> detectors = new ArrayList<PluginConfig>();
        PluginConfig detector = new PluginConfig("food", "org.opennms.netmgt.provision.persist.detectors.FoodDetector");
        detector.addParameter("type", "cheese");
        detector.addParameter("density", "soft");
        detector.addParameter("sharpness", "mild");
        detectors.add(detector);
        this.fs.setDetectors(detectors);
        ArrayList<PluginConfig> policies = new ArrayList<PluginConfig>();
        PluginConfig policy = new PluginConfig("lower-case-node", "org.opennms.netmgt.provision.persist.policies.NodeCategoryPolicy");
        policy.addParameter("label", "~^[a-z]$");
        policy.addParameter("category", "Lower-Case-Nodes");
        policies.add(policy);
        policy = new PluginConfig("all-ipinterfaces", "org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy");
        policies.add(policy);
        policy = new PluginConfig("10-ipinterfaces", "org.opennms.netmgt.provision.persist.policies.MatchingInterfacePolicy");
        policy.addParameter("ipaddress", "~^10\\..*$");
        policies.add(policy);
        policy = new PluginConfig("cisco-snmp-interfaces", "org.opennms.netmgt.provision.persist.policies.MatchingSnmpInterfacePolicy");
        policy.addParameter("ifdescr", "~^(?i:LEC).*$");
        policies.add(policy);
        this.fs.setPolicies(policies);
        this.fsw = new ForeignSourceCollection();
        this.fsw.getForeignSources().addAll(this.fsr.getForeignSources());
        this.c = JAXBContext.newInstance((Class[])new Class[]{ForeignSourceCollection.class, ForeignSource.class});
        this.m = this.c.createMarshaller();
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    @After
    public void tearDown() throws Exception {
        this.fa.tearDown();
    }

    @Test
    public void generateSchema() throws Exception {
        File schemaFile = this.fa.expecting("foreign-sources.xsd");
        this.c.generateSchema((SchemaOutputResolver)new TestOutputResolver(schemaFile));
        if (this.fa.isInitialized()) {
            this.fa.deleteExpected();
        }
    }

    @Test
    public void generateXML() throws Exception {
        StringWriter objectXML = new StringWriter();
        this.m.marshal((Object)this.fsw, (Writer)objectXML);
        StringBuffer exampleXML = new StringBuffer();
        File foreignSources = new File(ClassLoader.getSystemResource("foreign-sources.xml").getFile());
        Assert.assertTrue((String)"foreign-sources.xml is readable", (boolean)foreignSources.canRead());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(foreignSources), StandardCharsets.UTF_8));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            exampleXML.append(line).append("\n");
        }
        reader.close();
        System.err.println("========================================================================");
        System.err.println("Object XML:");
        System.err.println("========================================================================");
        System.err.print(objectXML.toString());
        System.err.println("========================================================================");
        System.err.println("Example XML:");
        System.err.println("========================================================================");
        System.err.print(exampleXML.toString());
        DetailedDiff myDiff = PersistenceSerializationTest.getDiff(objectXML, exampleXML);
        Assert.assertEquals((String)"number of XMLUnit differences between the example XML and the mock object XML is 0", (long)0L, (long)myDiff.getAllDifferences().size());
    }

    private static DetailedDiff getDiff(StringWriter objectXML, StringBuffer exampleXML) throws SAXException, IOException {
        DetailedDiff myDiff = new DetailedDiff(XMLUnit.compareXML((String)exampleXML.toString(), (String)objectXML.toString()));
        List allDifferences = myDiff.getAllDifferences();
        if (allDifferences.size() > 0) {
            for (Difference d : allDifferences) {
                System.err.println(d);
            }
        }
        return myDiff;
    }

    private static class TestOutputResolver
    extends SchemaOutputResolver {
        private final File m_schemaFile;

        public TestOutputResolver(File schemaFile) {
            this.m_schemaFile = schemaFile;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return new StreamResult(this.m_schemaFile);
        }
    }
}

