/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryTestCase;
import org.opennms.netmgt.provision.persist.MockForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.TestVisitor;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class MockForeignSourceRepositoryTest
extends ForeignSourceRepositoryTestCase {
    private String m_defaultForeignSourceName;
    private ForeignSourceRepository m_foreignSourceRepository;

    @Before
    public void setUp() {
        this.m_foreignSourceRepository = new MockForeignSourceRepository();
        this.m_defaultForeignSourceName = "imported:";
        this.m_foreignSourceRepository.clear();
        this.m_foreignSourceRepository.flush();
    }

    private Requisition createRequisition() throws Exception {
        return this.m_foreignSourceRepository.importResourceRequisition((Resource)new ClassPathResource("/requisition-test.xml"));
    }

    private ForeignSource createForeignSource(String foreignSource) throws Exception {
        ForeignSource fs = new ForeignSource(foreignSource);
        fs.addDetector(new PluginConfig("HTTP", "org.opennms.netmgt.provision.detector.simple.HttpDetector"));
        fs.addPolicy(new PluginConfig("all-ipinterfaces", "org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy"));
        this.m_foreignSourceRepository.save(fs);
        this.m_foreignSourceRepository.flush();
        return fs;
    }

    @Test
    public void testRequisition() throws Exception {
        this.createRequisition();
        Requisition r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        TestVisitor v = new TestVisitor();
        r.visit((RequisitionVisitor)v);
        Assert.assertEquals((String)"number of nodes visited", (long)2L, (long)v.getNodeReqs().size());
        Assert.assertEquals((String)"node name matches", (Object)"apknd", (Object)v.getNodeReqs().get(0).getNodeLabel());
    }

    @Test
    public void testForeignSource() throws Exception {
        this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        ArrayList foreignSources = new ArrayList(this.m_foreignSourceRepository.getForeignSources());
        Assert.assertEquals((String)"number of foreign sources", (long)1L, (long)foreignSources.size());
        Assert.assertEquals((String)"getAll() foreign source name matches", (Object)this.m_defaultForeignSourceName, (Object)((ForeignSource)foreignSources.get(0)).getName());
        Assert.assertEquals((String)"get() returns the foreign source", (Object)foreignSource, (Object)this.m_foreignSourceRepository.getForeignSource(this.m_defaultForeignSourceName));
    }

    @Test
    public void testBeanWrapperAccess() throws Exception {
        this.createRequisition();
        Requisition r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)r);
        Assert.assertEquals((Object)"AC", (Object)wrapper.getPropertyValue("node[0].category[0].name"));
        Assert.assertEquals((Object)"UK", (Object)wrapper.getPropertyValue("node[0].category[1].name"));
        Assert.assertEquals((Object)"low", (Object)wrapper.getPropertyValue("node[0].category[2].name"));
        try {
            wrapper.getPropertyValue("node[1].category[0].name");
            Assert.fail((String)"Did not catch expected InvalidPropertyException exception");
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)((RequisitionCategory[])wrapper.getPropertyValue("node[1].category")).length);
        wrapper.setPropertyValue("node[1].categories[0]", (Object)new RequisitionCategory("Hello world"));
        wrapper.setPropertyValue("node[1].categories[1]", (Object)new RequisitionCategory("Hello again"));
        Assert.assertEquals((long)2L, (long)((RequisitionCategory[])wrapper.getPropertyValue("node[1].category")).length);
    }

    @Test
    public void testGetRequisition() throws Exception {
        Requisition requisition = this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        this.assertRequisitionsMatch("foreign sources must match", this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName), this.m_foreignSourceRepository.getRequisition(foreignSource));
        this.assertRequisitionsMatch("foreign source is expected one", requisition, this.m_foreignSourceRepository.getRequisition(foreignSource));
    }
}

