/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_interfaces", "m_categories", "m_assets"})
@XmlRootElement(name="node")
public class RequisitionNode {
    @XmlElement(name="interface")
    protected List<RequisitionInterface> m_interfaces = new ArrayList<RequisitionInterface>();
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlElement(name="asset")
    protected List<RequisitionAsset> m_assets = new ArrayList<RequisitionAsset>();
    @XmlAttribute(name="building")
    protected String m_building;
    @XmlAttribute(name="city")
    protected String m_city;
    @XmlAttribute(name="foreign-id", required=true)
    protected String m_foreignId;
    @XmlAttribute(name="node-label", required=true)
    protected String m_nodeLabel;
    @XmlAttribute(name="parent-foreign-source")
    protected String m_parentForeignSource;
    @XmlAttribute(name="parent-foreign-id")
    protected String m_parentForeignId;
    @XmlAttribute(name="parent-node-label")
    protected String m_parentNodeLabel;

    @XmlTransient
    public int getInterfaceCount() {
        return this.m_interfaces == null ? 0 : this.m_interfaces.size();
    }

    @XmlTransient
    public RequisitionInterface[] getInterface() {
        return this.getInterfaces().toArray(new RequisitionInterface[0]);
    }

    public List<RequisitionInterface> getInterfaces() {
        return this.m_interfaces;
    }

    public void setInterfaces(Collection<RequisitionInterface> interfaces) {
        if (interfaces == null) {
            interfaces = new TreeSet<RequisitionInterface>();
        }
        if (this.m_interfaces == interfaces) {
            return;
        }
        this.m_interfaces.clear();
        this.m_interfaces.addAll(interfaces);
    }

    public RequisitionInterface getInterface(String ipAddress) {
        for (RequisitionInterface iface : this.m_interfaces) {
            if (!iface.getIpAddr().equals(ipAddress)) continue;
            return iface;
        }
        return null;
    }

    public boolean deleteInterface(RequisitionInterface iface) {
        return this.m_interfaces.remove(iface);
    }

    public boolean deleteInterface(String ipAddress) {
        Iterator<RequisitionInterface> i = this.m_interfaces.iterator();
        while (i.hasNext()) {
            RequisitionInterface iface = i.next();
            if (!iface.getIpAddr().equals(ipAddress)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public void putInterface(RequisitionInterface iface) {
        this.deleteInterface(iface.getIpAddr());
        this.m_interfaces.add(0, iface);
    }

    @XmlTransient
    public int getCategoryCount() {
        return this.m_categories == null ? 0 : this.m_categories.size();
    }

    @XmlTransient
    public RequisitionCategory[] getCategory() {
        return this.m_categories.toArray(new RequisitionCategory[0]);
    }

    public List<RequisitionCategory> getCategories() {
        return this.m_categories;
    }

    public void setCategories(Collection<RequisitionCategory> categories) {
        if (categories == null) {
            categories = new TreeSet<RequisitionCategory>();
        }
        if (this.m_categories == categories) {
            return;
        }
        this.m_categories.clear();
        this.m_categories.addAll(categories);
    }

    public RequisitionCategory getCategory(String category) {
        for (RequisitionCategory cat : this.m_categories) {
            if (!cat.getName().equals(category)) continue;
            return cat;
        }
        return null;
    }

    public boolean deleteCategory(RequisitionCategory category) {
        return this.m_categories.remove(category);
    }

    public boolean deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                return true;
            }
        }
        return false;
    }

    public void putCategory(RequisitionCategory category) {
        this.deleteCategory(category.getName());
        this.m_categories.add(0, category);
    }

    @XmlTransient
    public int getAssetCount() {
        return this.m_assets == null ? 0 : this.m_assets.size();
    }

    @XmlTransient
    public RequisitionAsset[] getAsset() {
        return this.m_assets.toArray(new RequisitionAsset[0]);
    }

    public List<RequisitionAsset> getAssets() {
        return this.m_assets;
    }

    public void setAssets(Collection<RequisitionAsset> assets) {
        if (assets == null) {
            assets = new TreeSet<RequisitionAsset>();
        }
        if (this.m_assets == assets) {
            return;
        }
        this.m_assets.clear();
        this.m_assets.addAll(assets);
    }

    public RequisitionAsset getAsset(String name) {
        for (RequisitionAsset asset : this.m_assets) {
            if (!asset.getName().equals(name)) continue;
            return asset;
        }
        return null;
    }

    public boolean deleteAsset(String name) {
        Iterator<RequisitionAsset> i = this.m_assets.iterator();
        while (i.hasNext()) {
            RequisitionAsset asset = i.next();
            if (!asset.getName().equals(name)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean deleteAsset(RequisitionAsset asset) {
        return this.m_assets.remove(asset);
    }

    public void putAsset(RequisitionAsset asset) {
        this.deleteAsset(asset.getName());
        this.m_assets.add(0, asset);
    }

    public String getBuilding() {
        return this.m_building;
    }

    public void setBuilding(String value) {
        this.m_building = value;
    }

    public String getCity() {
        return this.m_city;
    }

    public void setCity(String value) {
        this.m_city = value;
    }

    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String value) {
        this.m_foreignId = value;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String value) {
        this.m_nodeLabel = value;
    }

    public String getParentForeignSource() {
        return this.m_parentForeignSource;
    }

    public void setParentForeignSource(String value) {
        this.m_parentForeignSource = value != null && "".equals(value.trim()) ? null : value;
    }

    public String getParentForeignId() {
        return this.m_parentForeignId;
    }

    public void setParentForeignId(String value) {
        this.m_parentForeignId = value != null && "".equals(value.trim()) ? null : value;
    }

    public String getParentNodeLabel() {
        return this.m_parentNodeLabel;
    }

    public void setParentNodeLabel(String value) {
        this.m_parentNodeLabel = value != null && "".equals(value.trim()) ? null : value;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.m_building == null ? 0 : this.m_building.hashCode());
        result = 17 * result + (this.m_city == null ? 0 : this.m_city.hashCode());
        result = 17 * result + (this.m_foreignId == null ? 0 : this.m_foreignId.hashCode());
        result = 17 * result + (this.m_assets == null ? 0 : this.m_assets.hashCode());
        result = 17 * result + (this.m_categories == null ? 0 : this.m_categories.hashCode());
        result = 17 * result + (this.m_interfaces == null ? 0 : this.m_interfaces.hashCode());
        result = 17 * result + (this.m_nodeLabel == null ? 0 : this.m_nodeLabel.hashCode());
        result = 17 * result + (this.m_parentForeignId == null ? 0 : this.m_parentForeignId.hashCode());
        result = 17 * result + (this.m_parentForeignSource == null ? 0 : this.m_parentForeignSource.hashCode());
        result = 17 * result + (this.m_parentNodeLabel == null ? 0 : this.m_parentNodeLabel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequisitionNode)) {
            return false;
        }
        RequisitionNode other = (RequisitionNode)obj;
        if (this.m_building == null ? other.m_building != null : !this.m_building.equals(other.m_building)) {
            return false;
        }
        if (this.m_city == null ? other.m_city != null : !this.m_city.equals(other.m_city)) {
            return false;
        }
        if (this.m_foreignId == null ? other.m_foreignId != null : !this.m_foreignId.equals(other.m_foreignId)) {
            return false;
        }
        if (this.m_assets == null ? other.m_assets != null : !this.m_assets.equals(other.m_assets)) {
            return false;
        }
        if (this.m_categories == null ? other.m_categories != null : !this.m_categories.equals(other.m_categories)) {
            return false;
        }
        if (this.m_interfaces == null ? other.m_interfaces != null : !this.m_interfaces.equals(other.m_interfaces)) {
            return false;
        }
        if (this.m_nodeLabel == null ? other.m_nodeLabel != null : !this.m_nodeLabel.equals(other.m_nodeLabel)) {
            return false;
        }
        if (this.m_parentForeignId == null ? other.m_parentForeignId != null : !this.m_parentForeignId.equals(other.m_parentForeignId)) {
            return false;
        }
        if (this.m_parentForeignSource == null ? other.m_parentForeignSource != null : !this.m_parentForeignSource.equals(other.m_parentForeignSource)) {
            return false;
        }
        return !(this.m_parentNodeLabel == null ? other.m_parentNodeLabel != null : !this.m_parentNodeLabel.equals(other.m_parentNodeLabel));
    }

    public String toString() {
        return "RequisitionNode [interfaces=" + this.m_interfaces + ", categories=" + this.m_categories + ", assets=" + this.m_assets + ", building=" + this.m_building + ", city=" + this.m_city + ", foreignId=" + this.m_foreignId + ", nodeLabel=" + this.m_nodeLabel + ", parentForeignSource=" + this.m_parentForeignSource + ", parentForeignId=" + this.m_parentForeignId + ", parentNodeLabel=" + this.m_parentNodeLabel + "]";
    }
}

