/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/testForeignSourceContext.xml"})
@JUnitConfigurationEnvironment
public class RequisitionImplementationTest
implements InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionImplementationTest.class);
    private Map<String, ForeignSourceRepository> m_repositories;

    @Before
    @After
    public void cleanUp() throws Exception {
        if (this.m_repositories != null) {
            this.resetDirectories();
            for (ForeignSourceRepository fsr : this.m_repositories.values()) {
                fsr.flush();
                fsr.clear();
            }
        }
        LOG.info("Test context prepared.");
    }

    private void resetDirectories() throws IOException {
        FileUtils.deleteDirectory((File)new File("target/opennms-home/etc/imports"));
        FileUtils.forceMkdir((File)new File("target/opennms-home/etc/imports/pending"));
        FileUtils.deleteDirectory((File)new File("target/opennms-home/etc/foreign-sources"));
        FileUtils.forceMkdir((File)new File("target/opennms-home/etc/foreign-sources/pending"));
    }

    protected <T> void runTest(RepositoryTest<ForeignSourceRepository> rt, Class<? extends Throwable> expected) {
        this.m_repositories.entrySet().stream().forEach(entry -> {
            block3: {
                String bundleName = (String)entry.getKey();
                ForeignSourceRepository fsr = (ForeignSourceRepository)entry.getValue();
                LOG.info("=== " + bundleName + " ===");
                fsr.resetDefaultForeignSource();
                fsr.flush();
                try {
                    rt.test(fsr);
                }
                catch (Throwable t) {
                    if (expected == null) {
                        throw t;
                    }
                    LOG.debug("expected: {}, got: {}", (Object)expected, (Object)t);
                    if (t.getClass().getCanonicalName().equals(expected.getCanonicalName())) break block3;
                    throw new RuntimeException("Expected throwable " + expected.getName() + " when running test against " + bundleName + ", but got " + t.getClass() + " instead!", t);
                }
            }
        });
    }

    @Test
    public void testCreateSimpleRequisition() {
        this.runTest(fsr -> {
            Requisition req = fsr.importResourceRequisition((Resource)new ClassPathResource("/requisition-test.xml"));
            fsr.save(req);
            fsr.flush();
            req = fsr.getRequisition("imported:");
            Assert.assertNotNull((Object)req);
            Assert.assertEquals((long)2L, (long)req.getNodeCount());
        }, null);
    }

    @Test
    public void testCreateSimpleForeignSource() {
        this.runTest(fsr -> {
            ForeignSource fs = fsr.getForeignSource("blah");
            fs.setDefault(false);
            fsr.save(fs);
            fsr.flush();
            fs = fsr.getForeignSource("blah");
            Assert.assertNotNull((Object)fs);
            Assert.assertNotNull((Object)fs.getScanInterval());
        }, null);
    }

    @Test
    public void testRequisitionWithSpace() {
        this.runTest(fsr -> {
            Requisition req = new Requisition("foo bar");
            req.setDate(new Date(0L));
            fsr.save(req);
            fsr.flush();
            Requisition saved = fsr.getRequisition("foo bar");
            Assert.assertNotNull((Object)saved);
            Assert.assertEquals((Object)req, (Object)saved);
        }, null);
    }

    @Test
    public void testRequisitionWithSlash() {
        this.runTest(fsr -> {
            Requisition req = new Requisition("foo/bar");
            req.setForeignSource("foo/bar");
            fsr.save(req);
        }, ForeignSourceRepositoryException.class);
    }

    @Test
    public void testForeignSourceWithSpace() {
        this.runTest(fsr -> {
            ForeignSource fs = fsr.getForeignSource("foo bar");
            fs.setDefault(false);
            fsr.save(fs);
            fsr.flush();
            ForeignSource saved = fsr.getForeignSource("foo bar");
            Assert.assertNotNull((Object)saved);
            Assert.assertEquals((Object)fs, (Object)saved);
        }, null);
    }

    @Test
    public void testForeignSourceWithSlash() {
        this.runTest(fsr -> {
            ForeignSource fs = fsr.getForeignSource("foo/bar");
            fs.setDefault(false);
            fsr.save(fs);
            fsr.flush();
            ForeignSource saved = fsr.getForeignSource("foo/bar");
            Assert.assertNotNull((Object)saved);
            Assert.assertEquals((Object)fs, (Object)saved);
        }, ForeignSourceRepositoryException.class);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.m_repositories = context.getBeansOfType(ForeignSourceRepository.class);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull(this.m_repositories);
    }

    static interface RepositoryTest<T> {
        public void test(T var1);
    }
}

