/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.apache.commons.io.FileUtils;

class FileSystemBuilder {
    private File m_baseDir;
    private Stack<File> m_dirs = new Stack();

    public FileSystemBuilder(String dir, String name) {
        this.m_baseDir = new File(dir, name);
        this.m_baseDir.delete();
        this.m_baseDir.mkdirs();
        this.m_baseDir.deleteOnExit();
        this.m_dirs.push(this.m_baseDir);
    }

    public File getCurrentDir() {
        return this.m_dirs.peek();
    }

    public File pop() {
        return this.m_dirs.pop();
    }

    public FileSystemBuilder dir(String name) {
        File dir = new File(this.getCurrentDir(), name);
        dir.mkdirs();
        dir.deleteOnExit();
        this.m_dirs.push(dir);
        return this;
    }

    public FileSystemBuilder file(String name) throws IOException {
        return this.file(name, "");
    }

    public FileSystemBuilder file(String name, String contents) throws IOException {
        File file = new File(this.getCurrentDir(), name);
        FileUtils.writeStringToFile((File)file, (String)contents);
        file.deleteOnExit();
        return this;
    }

    public void cleanup() throws IOException {
        this.m_dirs.clear();
        FileUtils.deleteDirectory((File)this.m_baseDir);
    }
}

