/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher<T>
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryWatcher.class);
    private Path m_path;
    private Thread m_thread;
    private File m_directory;
    private FileReloadCallback<T> m_loader;
    private ConcurrentHashMap<String, FileReloadContainer<T>> m_contents = new ConcurrentHashMap();

    public DirectoryWatcher(File directory, FileReloadCallback<T> loader) throws InterruptedException {
        this.m_directory = directory;
        if (!this.m_directory.exists() && !this.m_directory.mkdirs()) {
            LOG.warn("Could not make directory: {}", (Object)this.m_directory.getPath());
        }
        this.m_loader = loader;
        if (this.m_directory != null) {
            this.m_path = Paths.get(this.m_directory.getAbsolutePath(), new String[0]);
            this.start();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            LOG.warn("request to stop failed, guess its time to stop being polite!");
        }
    }

    public void join() throws InterruptedException {
        this.m_thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            LOG.debug("registering create watcher on " + this.m_path.toAbsolutePath().toString());
            this.m_path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            LOG.debug("watcher registration complete for " + this.m_path.toAbsolutePath().toString());
            DirectoryWatcher directoryWatcher = this;
            synchronized (directoryWatcher) {
                this.notifyAll();
            }
            block26: while (!this.m_thread.isInterrupted()) {
                WatchKey key = null;
                try {
                    LOG.debug("waiting for create event");
                    key = watcher.take();
                    LOG.debug("got an event, process it");
                }
                catch (InterruptedException ie) {
                    LOG.info("interruped, must be time to shut down...");
                    break;
                }
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (true) {
                    WatchEvent<?> eventUnknown;
                    if (!iterator.hasNext()) continue block26;
                    WatchEvent<?> event = eventUnknown = iterator.next();
                    WatchEvent.Kind<?> kind = event.kind();
                    String fileName = ((Path)event.context()).toString();
                    File file = new File(this.m_directory, fileName);
                    if (file.isDirectory()) continue;
                    switch (kind.name()) {
                        case "ENTRY_CREATE": {
                            LOG.info("created {} in {}.", (Object)fileName, (Object)this.m_directory);
                            this.getContents(fileName);
                            break;
                        }
                        case "ENTRY_MODIFY": {
                            LOG.info("modified {} in {}.", (Object)fileName, (Object)this.m_directory);
                            this.m_contents.remove(fileName);
                            this.getContents(fileName);
                            break;
                        }
                        case "ENTRY_DELETE": {
                            LOG.info("deleted {} from {}.", (Object)fileName, (Object)this.m_directory);
                            this.m_contents.remove(fileName);
                        }
                    }
                    if (!key.reset()) break;
                }
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
        }
        LOG.info("existing run loop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        LOG.trace("starting monitor");
        this.m_thread = new Thread((Runnable)this, "DirectoryWatcher-" + this.m_directory.getName());
        this.m_thread.start();
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.wait();
        }
        LOG.trace("monitor started");
    }

    public void stop() throws InterruptedException {
        LOG.trace("stopping monitor");
        this.m_thread.interrupt();
        this.m_thread.join();
        this.m_thread = null;
        LOG.trace("monitor stopped");
    }

    public Set<String> getFileNames() {
        return new LinkedHashSet<String>(Arrays.asList(this.m_directory.list()));
    }

    public Set<String> getBaseNamesWithExtension(String extension) {
        Set<String> fileNames = this.getFileNames();
        LinkedHashSet<String> basenames = new LinkedHashSet<String>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith(extension)) continue;
            String basename = fileName.substring(0, fileName.length() - extension.length());
            basenames.add(basename);
        }
        return basenames;
    }

    public T getContents(String fileName) throws FileNotFoundException {
        File file = new File(this.m_directory, fileName);
        if (file.exists()) {
            FileReloadContainer newContainer = new FileReloadContainer(file, this.m_loader);
            newContainer.setReloadCheckInterval(0L);
            FileReloadContainer container = this.m_contents.putIfAbsent(file.getName(), newContainer);
            if (container == null) {
                container = newContainer;
            }
            return (T)container.getObject();
        }
        this.m_contents.remove(fileName);
        throw new FileNotFoundException("there is no file " + fileName + " in directory " + this.m_directory);
    }
}

