/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.bind.ValidationException;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public abstract class AbstractForeignSourceRepository
implements ForeignSourceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForeignSourceRepository.class);

    @Override
    public Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        Assert.notNull((Object)resource);
        LOG.debug("importing requisition from {}", (Object)resource);
        Requisition requisition = (Requisition)JaxbUtils.unmarshal(Requisition.class, (Resource)resource);
        requisition.setResource(resource);
        this.save(requisition);
        return requisition;
    }

    @Override
    public ForeignSource getDefaultForeignSource() throws ForeignSourceRepositoryException {
        ClassPathResource defaultForeignSource = new ClassPathResource("/default-foreign-source.xml");
        if (!defaultForeignSource.exists()) {
            defaultForeignSource = new ClassPathResource("/org/opennms/netmgt/provision/persist/default-foreign-source.xml");
        }
        ForeignSource fs = (ForeignSource)JaxbUtils.unmarshal(ForeignSource.class, (Resource)defaultForeignSource);
        fs.setDefault(true);
        return fs;
    }

    @Override
    public void putDefaultForeignSource(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("foreign source was null");
        }
        foreignSource.setName("default");
        File outputFile = new File(ConfigFileConstants.getFilePathString() + "default-foreign-source.xml");
        OutputStreamWriter writer = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            JaxbUtils.marshal((Object)foreignSource, (Writer)writer);
        }
        catch (Throwable e) {
            try {
                throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    @Override
    public void resetDefaultForeignSource() throws ForeignSourceRepositoryException {
        File deleteFile = new File(ConfigFileConstants.getFilePathString() + "default-foreign-source.xml");
        if (!deleteFile.exists()) {
            return;
        }
        if (!deleteFile.delete()) {
            LOG.warn("unable to remove {}", (Object)deleteFile.getPath());
        }
    }

    @Override
    public OnmsNodeRequisition getNodeRequisition(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        Requisition req = this.getRequisition(foreignSource);
        return req == null ? null : req.getNodeRequistion(foreignId);
    }

    @Override
    public void validate(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        String name = foreignSource.getName();
        if (name.contains("/")) {
            throw new ForeignSourceRepositoryException("Foreign Source (" + name + ") contains invalid characters. ('/' is forbidden.)");
        }
    }

    @Override
    public void validate(Requisition requisition) throws ForeignSourceRepositoryException {
        try {
            requisition.validate();
        }
        catch (ValidationException e) {
            throw new ForeignSourceRepositoryException(e.getMessage(), e);
        }
    }

    @Override
    public void clear() throws ForeignSourceRepositoryException {
        for (Requisition req : this.getRequisitions()) {
            if (req == null) continue;
            this.delete(req);
        }
        for (ForeignSource fs : this.getForeignSources()) {
            if (fs == null) continue;
            this.delete(fs);
        }
    }
}

