/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryTestCase;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class FusedForeignSourceRepositoryTest
extends ForeignSourceRepositoryTestCase {
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pending;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_active;
    @Autowired
    @Qualifier(value="fused")
    private ForeignSourceRepository m_repository;

    @Before
    public void setUp() throws IOException {
        Properties props = new Properties();
        props.put("log4j.logger.org.opennms.core.xml.SimpleNamespaceFilter", "WARN");
        props.put("log4j.logger.org.opennms.netmgt.provision.persist.RequisitionFileUtils", "TRACE");
        MockLogAppender.setupLogging((Properties)props);
        System.err.println("setUp()");
        for (ForeignSource fs : this.m_pending.getForeignSources()) {
            this.m_pending.delete(fs);
        }
        for (ForeignSource fs : this.m_active.getForeignSources()) {
            this.m_active.delete(fs);
        }
        for (Requisition r : this.m_pending.getRequisitions()) {
            this.m_pending.delete(r);
        }
        for (Requisition r : this.m_active.getRequisitions()) {
            this.m_active.delete(r);
        }
        FileUtils.deleteDirectory((File)new File("target/opennms-home/etc/imports/pending"));
        this.m_pending.flush();
        this.m_active.flush();
    }

    @After
    public final void tearDown() {
        for (ForeignSource fs : this.m_pending.getForeignSources()) {
            this.m_pending.delete(fs);
        }
        for (ForeignSource fs : this.m_active.getForeignSources()) {
            this.m_active.delete(fs);
        }
        for (Requisition r : this.m_pending.getRequisitions()) {
            this.m_pending.delete(r);
        }
        for (Requisition r : this.m_active.getRequisitions()) {
            this.m_active.delete(r);
        }
        this.m_pending.flush();
        this.m_active.flush();
    }

    @Test
    public void simpleSnapshotTest() throws URISyntaxException {
        Requisition pendingReq = new Requisition("test");
        pendingReq.putNode(this.createNode("1"));
        this.m_pending.save(pendingReq);
        this.m_pending.flush();
        pendingReq = this.m_pending.getRequisition(pendingReq.getForeignSource());
        File pendingSnapshot = RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_pending, (String)pendingReq.getForeignSource(), (Date)pendingReq.getDate());
        this.m_repository.importResourceRequisition((Resource)new FileSystemResource(pendingSnapshot));
        Assert.assertFalse((boolean)pendingSnapshot.exists());
        URL pendingUrl = this.m_pending.getRequisitionURL(pendingReq.getForeignSource());
        File pendingFile = new File(pendingUrl.toURI());
        Assert.assertFalse((boolean)pendingFile.exists());
    }

    @Test
    public void multipleSnapshotTest() throws URISyntaxException, InterruptedException {
        Requisition pendingReq = new Requisition("test");
        pendingReq.putNode(this.createNode("1"));
        this.m_pending.save(pendingReq);
        this.m_pending.flush();
        String foreignSource = pendingReq.getForeignSource();
        pendingReq = this.m_pending.getRequisition(foreignSource);
        File pendingSnapshotA = RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_pending, (String)foreignSource, (Date)pendingReq.getDate());
        pendingReq.updateDateStamp();
        this.m_pending.save(pendingReq);
        this.m_pending.flush();
        File pendingSnapshotB = RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_pending, (String)foreignSource, (Date)pendingReq.getDate());
        this.m_repository.importResourceRequisition((Resource)new FileSystemResource(pendingSnapshotA));
        Assert.assertFalse((boolean)pendingSnapshotA.exists());
        Assert.assertTrue((boolean)pendingSnapshotB.exists());
        URL pendingUrl = this.m_pending.getRequisitionURL(foreignSource);
        Assert.assertNotNull((Object)pendingUrl);
        Assert.assertFalse((boolean)new File(pendingUrl.toURI()).exists());
        Requisition bReq = this.m_repository.importResourceRequisition((Resource)new FileSystemResource(pendingSnapshotB));
        Assert.assertFalse((boolean)pendingSnapshotA.exists());
        Assert.assertFalse((boolean)pendingSnapshotB.exists());
        pendingUrl = this.m_pending.getRequisitionURL(foreignSource);
        Assert.assertNotNull((Object)pendingUrl);
        Assert.assertFalse((boolean)new File(pendingUrl.toURI()).exists());
        Requisition deployedRequisition = this.m_active.getRequisition(foreignSource);
        Assert.assertEquals((long)deployedRequisition.getDate().getTime(), (long)bReq.getDate().getTime());
    }

    @Test
    public void integrationTest() {
        Requisition pendingReq = new Requisition("test");
        pendingReq.putNode(this.createNode("1"));
        this.m_pending.save(pendingReq);
        this.m_pending.flush();
        ForeignSource pendingSource = this.m_repository.getForeignSource("test");
        Assert.assertTrue((boolean)pendingSource.isDefault());
        pendingSource.setDetectors(new ArrayList());
        this.m_pending.save(pendingSource);
        this.m_pending.flush();
        Requisition activeReq = this.m_repository.importResourceRequisition((Resource)new UrlResource(this.m_pending.getRequisitionURL("test")));
        ForeignSource activeSource = this.m_active.getForeignSource("test");
        Assert.assertEquals((Object)activeSource.getName(), (Object)pendingSource.getName());
        Assert.assertEquals((Object)activeSource.getDetectorNames(), (Object)pendingSource.getDetectorNames());
        Assert.assertEquals((Object)activeSource.getScanInterval(), (Object)pendingSource.getScanInterval());
        this.assertRequisitionsMatch("active and pending requisitions should match", activeReq, pendingReq);
        Assert.assertNull((String)"the requisition should be null in the pending repo", (Object)this.m_pending.getRequisition("test"));
        Assert.assertTrue((String)"the foreign source should be default since there's no specific in the pending repo", (boolean)this.m_pending.getForeignSource("test").isDefault());
    }

    @Test
    public void testSpc674RaceCondition() throws Exception {
        String foreignSource = "spc674";
        System.err.println("=== create a requisition like the ReST service does, import it immediately ===");
        Requisition initial = new Requisition("spc674");
        initial.putNode(this.createNode("1"));
        initial.updateDateStamp();
        this.m_pending.save(initial);
        URL node1Snapshot = this.createSnapshot("spc674");
        UrlResource resource = new UrlResource(node1Snapshot);
        this.doImport((Resource)resource);
        Thread.sleep(5L);
        List<String> files = this.getImports("spc674");
        Assert.assertEquals((long)1L, (long)files.size());
        System.err.println("=== create another snapshot, but don't import it yet ===");
        initial.putNode(this.createNode("2"));
        initial.updateDateStamp();
        this.m_pending.save(initial);
        URL node2Snapshot = this.createSnapshot("spc674");
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)3L, (long)files.size());
        System.err.println("=== create yet another snapshot, and don't import it yet ===");
        initial.putNode(this.createNode("3"));
        initial.updateDateStamp();
        this.m_pending.save(initial);
        URL node3Snapshot = this.createSnapshot("spc674");
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)4L, (long)files.size());
        System.err.println("=== import of the second file finishes ===");
        this.doImport((Resource)new UrlResource(node2Snapshot));
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)2L, (long)files.size());
        System.err.println("=== fourth node is sent to the ReST interface ===");
        Requisition currentPending = RequisitionFileUtils.getLatestPendingOrSnapshotRequisition((ForeignSourceRepository)this.m_pending, (String)"spc674");
        Assert.assertNotNull((Object)currentPending);
        Assert.assertEquals((Object)initial.getDate(), (Object)currentPending.getDate());
        currentPending.putNode(this.createNode("4"));
        currentPending.updateDateStamp();
        this.m_pending.save(currentPending);
        URL node4Snapshot = this.createSnapshot("spc674");
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)4L, (long)files.size());
        System.err.println("=== import of the third file finishes ===");
        this.doImport((Resource)new UrlResource(node3Snapshot));
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)2L, (long)files.size());
        System.err.println("=== import of the fourth file finishes ===");
        this.doImport((Resource)new UrlResource(node4Snapshot));
        Thread.sleep(5L);
        files = this.getImports("spc674");
        Assert.assertEquals((long)1L, (long)files.size());
    }

    protected List<String> getImports(String foreignSource) {
        ArrayList<String> entries = new ArrayList<String>();
        File importsDirectory = new File("target/opennms-home/etc/imports");
        for (File file : importsDirectory.listFiles()) {
            if (!file.getName().startsWith(foreignSource + ".xml")) continue;
            entries.add(this.getSummaryForRequisition(file));
        }
        File pendingDirectory = new File("target/opennms-home/etc/imports/pending");
        for (File file : pendingDirectory.listFiles()) {
            if (!file.getName().startsWith(foreignSource + ".xml")) continue;
            entries.add(this.getSummaryForRequisition(file));
        }
        System.err.println("--- BEGIN REQUISITIONS ---");
        Collections.sort(entries);
        for (String entry : entries) {
            System.err.println(entry);
        }
        System.err.println("--- END REQUISITIONS ---");
        return entries;
    }

    protected String getSummaryForRequisition(File file) {
        Requisition requisition = (Requisition)JaxbUtils.unmarshal(Requisition.class, (Resource)new FileSystemResource(file));
        StringBuilder sb = new StringBuilder();
        if (requisition.getNodeCount() > 0) {
            sb.append("(");
            Iterator nodeIterator = requisition.getNodes().iterator();
            while (nodeIterator.hasNext()) {
                sb.append(((RequisitionNode)nodeIterator.next()).getNodeLabel());
                if (!nodeIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        String requisitionSummary = file.getPath() + sb.toString() + ": " + requisition.getDate().getTime();
        return requisitionSummary;
    }

    protected URL createSnapshot(String foreignSource) throws MalformedURLException {
        Date pendingDate;
        System.err.println("--- creating snapshot for " + foreignSource + " ---");
        Requisition pending = this.m_pending.getRequisition(foreignSource);
        Requisition deployed = this.m_active.getRequisition(foreignSource);
        Date deployedDate = deployed == null ? null : deployed.getDate();
        Date date = pendingDate = pending == null ? null : pending.getDate();
        if (deployedDate == null) {
            return RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_pending, (String)foreignSource, (Date)pending.getDate()).toURI().toURL();
        }
        if (pendingDate == null) {
            return this.m_active.getRequisitionURL(foreignSource);
        }
        URL url = deployedDate.before(pendingDate) ? RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_pending, (String)foreignSource, (Date)pendingDate).toURI().toURL() : this.m_active.getRequisitionURL(foreignSource);
        System.err.println("deployedDate = " + deployedDate);
        System.err.println("pendingDate  = " + pendingDate);
        System.err.println("url          = " + url);
        return url;
    }

    protected void doImport(Resource resource) {
        Requisition req = this.m_repository.importResourceRequisition(resource);
        req.updateLastImported();
        this.m_repository.save(req);
    }

    protected RequisitionNode createNode(String id) {
        RequisitionNode node = new RequisitionNode();
        node.setForeignId(id);
        node.setNodeLabel("node " + id);
        RequisitionInterface iface = new RequisitionInterface();
        iface.setIpAddr("172.16.0." + id);
        node.putInterface(iface);
        return node;
    }
}

