/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import org.opennms.netmgt.provision.persist.FactoryStrategy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

public class DefaultForeignSourceRepositoryFactory
implements ForeignSourceRepositoryFactory,
InitializingBean {
    public static final String REPOSITORY_IMPLEMENTATION = "org.opennms.provisiond.repositoryImplementation";
    @Autowired
    @Qualifier(value="filePending")
    private ForeignSourceRepository m_filePendingRepository;
    @Autowired
    @Qualifier(value="fileDeployed")
    private ForeignSourceRepository m_fileDeployedRepository;
    @Autowired
    @Qualifier(value="fastFilePending")
    private ForeignSourceRepository m_fastFilePendingRepository;
    @Autowired
    @Qualifier(value="fastFileDeployed")
    private ForeignSourceRepository m_fastFileDeployedRepository;
    @Autowired
    @Qualifier(value="fused")
    private ForeignSourceRepository m_fusedRepository;
    @Autowired
    @Qualifier(value="fastFused")
    private ForeignSourceRepository m_fastFusedRepository;
    @Autowired
    @Qualifier(value="caching")
    private ForeignSourceRepository m_cachingRepository;
    @Autowired
    @Qualifier(value="fastCaching")
    private ForeignSourceRepository m_fastCachingRepository;
    @Autowired
    @Qualifier(value="queueing")
    private ForeignSourceRepository m_queueingRepository;
    @Autowired
    @Qualifier(value="fastQueueing")
    private ForeignSourceRepository m_fastQueueingRepository;

    @Override
    public ForeignSourceRepository getPendingRepository() {
        switch (this.getRepositoryStrategy()) {
            case fastQueueing: {
                return this.m_fastQueueingRepository;
            }
            case queueing: {
                return this.m_queueingRepository;
            }
            case fastCaching: {
                return this.m_fastCachingRepository;
            }
            case caching: {
                return this.m_cachingRepository;
            }
            case fastFused: {
                return this.m_fastFusedRepository;
            }
            case fused: {
                return this.m_fusedRepository;
            }
            case fastFile: {
                return this.m_fastFilePendingRepository;
            }
        }
        return this.m_filePendingRepository;
    }

    @Override
    public ForeignSourceRepository getDeployedRepository() {
        switch (this.getRepositoryStrategy()) {
            case fastQueueing: {
                return this.m_fastQueueingRepository;
            }
            case queueing: {
                return this.m_queueingRepository;
            }
            case fastCaching: {
                return this.m_fastCachingRepository;
            }
            case caching: {
                return this.m_cachingRepository;
            }
            case fastFused: {
                return this.m_fastFusedRepository;
            }
            case fused: {
                return this.m_fusedRepository;
            }
            case fastFile: {
                return this.m_fastFileDeployedRepository;
            }
        }
        return this.m_fileDeployedRepository;
    }

    @Override
    public FactoryStrategy getRepositoryStrategy() {
        return FactoryStrategy.valueOf(System.getProperty(REPOSITORY_IMPLEMENTATION, "file"));
    }

    @Override
    public synchronized void setRepositoryStrategy(FactoryStrategy strategy) {
        if (strategy != null) {
            this.getDeployedRepository().flush();
            this.getPendingRepository().flush();
            System.setProperty(REPOSITORY_IMPLEMENTATION, strategy.toString());
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_fastQueueingRepository);
        Assert.notNull((Object)this.m_queueingRepository);
        Assert.notNull((Object)this.m_fastCachingRepository);
        Assert.notNull((Object)this.m_cachingRepository);
        Assert.notNull((Object)this.m_fastFusedRepository);
        Assert.notNull((Object)this.m_fusedRepository);
        Assert.notNull((Object)this.m_fastFileDeployedRepository);
        Assert.notNull((Object)this.m_fastFilePendingRepository);
        Assert.notNull((Object)this.m_fileDeployedRepository);
        Assert.notNull((Object)this.m_filePendingRepository);
    }
}

