/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.SnmpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Match SNMP Interface")
public class MatchingSnmpInterfacePolicy
extends BasePolicy<OnmsSnmpInterface>
implements SnmpInterfacePolicy {
    private Action m_action = Action.DO_NOT_PERSIST;

    @Require(value={"ENABLE_COLLECTION", "DISABLE_COLLECTION", "DO_NOT_PERSIST", "ENABLE_POLLING", "DISABLE_POLLING"})
    public String getAction() {
        return this.m_action.toString();
    }

    public void setAction(String action) {
        this.m_action = action != null && action.toUpperCase().equals("ENABLE_COLLECTION") ? Action.ENABLE_COLLECTION : (action != null && action.toUpperCase().equals("DISABLE_COLLECTION") ? Action.DISABLE_COLLECTION : (action != null && action.toUpperCase().equals("ENABLE_POLLING") ? Action.ENABLE_POLLING : (action != null && action.toUpperCase().equals("DISABLE_POLLING") ? Action.DISABLE_POLLING : Action.DO_NOT_PERSIST)));
    }

    public OnmsSnmpInterface act(OnmsSnmpInterface iface) {
        switch (this.m_action) {
            case DO_NOT_PERSIST: {
                LogUtils.debugf((Object)((Object)this), (String)"NOT Persisting %s according to policy", (Object[])new Object[]{iface});
                return null;
            }
            case DISABLE_COLLECTION: {
                iface.setCollectionEnabled(false);
                LogUtils.debugf((Object)((Object)this), (String)"Disabled collection for %s according to policy", (Object[])new Object[]{iface});
                return iface;
            }
            case ENABLE_COLLECTION: {
                iface.setCollectionEnabled(true);
                LogUtils.debugf((Object)((Object)this), (String)"Enabled collection for %s according to policy", (Object[])new Object[]{iface});
                return iface;
            }
            case ENABLE_POLLING: {
                iface.setPoll("P");
                LogUtils.debugf((Object)((Object)this), (String)"Enabled polling for %s according to policy", (Object[])new Object[]{iface});
                return iface;
            }
            case DISABLE_POLLING: {
                iface.setPoll("N");
                LogUtils.debugf((Object)((Object)this), (String)"Disabled polling for %s according to policy", (Object[])new Object[]{iface});
                return iface;
            }
        }
        return iface;
    }

    public String getIfDescr() {
        return this.getCriteria("ifDescr");
    }

    public void setIfDescr(String ifDescr) {
        this.putCriteria("ifDescr", ifDescr);
    }

    public String getIfName() {
        return this.getCriteria("ifName");
    }

    public void setIfName(String ifName) {
        this.putCriteria("ifName", ifName);
    }

    public String getIfType() {
        return this.getCriteria("ifType");
    }

    public void setIfType(String ifType) {
        this.putCriteria("ifType", ifType);
    }

    public String getPhysAddr() {
        return this.getCriteria("physAddr");
    }

    public void setPhysAddr(String physAddr) {
        this.putCriteria("physAddr", physAddr);
    }

    public String getIfIndex() {
        return this.getCriteria("ifIndex");
    }

    public void setIfIndex(String ifIndex) {
        this.putCriteria("ifIndex", ifIndex);
    }

    public String getIfSpeed() {
        return this.getCriteria("ifSpeed");
    }

    public void setIfSpeed(String ifSpeed) {
        this.putCriteria("ifSpeed", ifSpeed);
    }

    public String getIfAdminStatus() {
        return this.getCriteria("ifAdminStatus");
    }

    public void setIfAdminStatus(String ifAdminStatus) {
        this.putCriteria("ifAdminStatus", ifAdminStatus);
    }

    public String getIfOperStatus() {
        return this.getCriteria("ifOperStatus");
    }

    public void setIfOperStatus(String ifOperStatus) {
        this.putCriteria("ifOperStatus", ifOperStatus);
    }

    public String getIfAlias() {
        return this.getCriteria("ifAlias");
    }

    public void setIfAlias(String ifAlias) {
        this.putCriteria("ifAlias", ifAlias);
    }

    public static enum Action {
        ENABLE_COLLECTION,
        DISABLE_COLLECTION,
        DO_NOT_PERSIST,
        ENABLE_POLLING,
        DISABLE_POLLING;

    }
}

