/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.IpInterfacePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Match IP Interface")
public class MatchingIpInterfacePolicy
extends BasePolicy<OnmsIpInterface>
implements IpInterfacePolicy {
    private Action m_action = Action.DO_NOT_PERSIST;

    @Require(value={"MANAGE", "UNMANAGE", "DO_NOT_PERSIST", "ENABLE_SNMP_POLL", "DISABLE_SNMP_POLL", "ENABLE_COLLECTION", "DISABLE_COLLECTION"})
    public String getAction() {
        return this.m_action.toString();
    }

    public void setAction(String action) {
        this.m_action = Action.MANAGE.toString().equalsIgnoreCase(action) ? Action.MANAGE : (Action.UNMANAGE.toString().equalsIgnoreCase(action) ? Action.UNMANAGE : (Action.ENABLE_SNMP_POLL.toString().equalsIgnoreCase(action) ? Action.ENABLE_SNMP_POLL : (Action.DISABLE_SNMP_POLL.toString().equalsIgnoreCase(action) ? Action.DISABLE_SNMP_POLL : (action != null && action.toUpperCase().equals("ENABLE_COLLECTION") ? Action.ENABLE_COLLECTION : (action != null && action.toUpperCase().equals("DISABLE_COLLECTION") ? Action.DISABLE_COLLECTION : Action.DO_NOT_PERSIST)))));
    }

    public OnmsIpInterface act(OnmsIpInterface iface) {
        OnmsSnmpInterface snmpiface = iface.getSnmpInterface();
        switch (this.m_action) {
            case DO_NOT_PERSIST: {
                LogUtils.debugf((Object)((Object)this), (String)"NOT Persisting %s according to policy", (Object[])new Object[]{iface});
                return null;
            }
            case MANAGE: {
                LogUtils.debugf((Object)((Object)this), (String)"Managing %s according to policy", (Object[])new Object[]{iface});
                iface.setIsManaged("M");
                return iface;
            }
            case UNMANAGE: {
                LogUtils.debugf((Object)((Object)this), (String)"Unmanaging %s according to policy", (Object[])new Object[]{iface});
                iface.setIsManaged("U");
                return iface;
            }
            case ENABLE_SNMP_POLL: {
                LogUtils.debugf((Object)((Object)this), (String)"SNMP polling %s according to policy", (Object[])new Object[]{iface});
                snmpiface.setPoll("P");
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case DISABLE_SNMP_POLL: {
                LogUtils.debugf((Object)((Object)this), (String)"Disable SNMP polling %s according to policy", (Object[])new Object[]{iface});
                snmpiface.setPoll("N");
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case DISABLE_COLLECTION: {
                LogUtils.debugf((Object)((Object)this), (String)"Disabled collection for %s according to policy", (Object[])new Object[]{iface});
                snmpiface.setCollectionEnabled(false);
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
            case ENABLE_COLLECTION: {
                LogUtils.debugf((Object)((Object)this), (String)"Enabled collection for %s according to policy", (Object[])new Object[]{iface});
                snmpiface.setCollectionEnabled(true);
                iface.setSnmpInterface(snmpiface);
                return iface;
            }
        }
        return iface;
    }

    public void setIpAddress(String ipAddress) {
        this.putCriteria("ipAddress", ipAddress);
    }

    public String getIpAddress() {
        return this.getCriteria("ipAddress");
    }

    public void setHostName(String hostName) {
        this.putCriteria("ipHostName", hostName);
    }

    public String getHostName() {
        return this.getCriteria("ipHostName");
    }

    public static enum Action {
        MANAGE,
        UNMANAGE,
        DO_NOT_PERSIST,
        ENABLE_SNMP_POLL,
        DISABLE_SNMP_POLL,
        ENABLE_COLLECTION,
        DISABLE_COLLECTION;

    }
}

