/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.foreignsource;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.provision.persist.foreignsource.PluginParameter;
import org.opennms.netmgt.provision.support.PluginWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="plugin")
public class PluginConfig
implements Serializable,
Comparable<PluginConfig> {
    private static final long serialVersionUID = 4307231598310473690L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="class")
    private String m_pluginClass;
    @XmlElement(name="parameter")
    private Set<PluginParameter> m_parameters = new LinkedHashSet<PluginParameter>();

    public PluginConfig() {
    }

    public PluginConfig(String name, String clazz) {
        this.setName(name);
        this.setPluginClass(clazz);
    }

    public PluginConfig(PluginConfig pluginConfig) {
        this.setName(pluginConfig.getName());
        this.setPluginClass(pluginConfig.getPluginClass());
        this.setParameterMap(pluginConfig.getParameterMap());
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPluginClass() {
        return this.m_pluginClass;
    }

    public void setPluginClass(String clazz) {
        this.m_pluginClass = clazz;
    }

    public Set<PluginParameter> getParameters() {
        for (PluginParameter p : this.m_parameters) {
            p.setPluginConfig(this);
        }
        return this.m_parameters;
    }

    public void setParameters(Set<PluginParameter> list) {
        for (PluginParameter p : list) {
            p.setPluginConfig(this);
        }
        this.m_parameters = list;
    }

    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> parms = new LinkedHashMap<String, String>();
        for (PluginParameter p : this.getParameters()) {
            parms.put(p.getKey(), p.getValue());
        }
        return Collections.unmodifiableMap(parms);
    }

    public void setParameterMap(Map<String, String> parameters) {
        this.m_parameters.clear();
        for (Map.Entry<String, String> set : parameters.entrySet()) {
            this.m_parameters.add(new PluginParameter(this, set));
        }
    }

    public String getParameter(String key) {
        for (PluginParameter p : this.getParameters()) {
            if (!p.getKey().equals(key)) continue;
            return p.getValue();
        }
        return null;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.add(new PluginParameter(this, key, value));
    }

    public void deleteParameters(PluginParameter p) {
        this.m_parameters.remove(p);
    }

    public Set<String> getAvailableParameterKeys() {
        Set<String> keys = new TreeSet<String>();
        try {
            PluginWrapper pw = new PluginWrapper(this.m_pluginClass);
            keys = pw.getOptionalKeys();
            for (PluginParameter p : this.getParameters()) {
                keys.remove(p.getKey());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return keys;
    }

    private String getParametersAsString() {
        StringBuilder sb = new StringBuilder();
        for (PluginParameter p : this.getParameters()) {
            sb.append(p.getKey()).append('=').append(p.getValue()).append('/');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(PluginConfig obj) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)obj.getName()).append((Object)this.getPluginClass(), (Object)obj.getPluginClass()).append((Object)this.getParametersAsString(), (Object)obj.getParametersAsString()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("plugin-class", (Object)this.getPluginClass()).append("parameters", (Object)this.getParametersAsString()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PluginConfig) {
            PluginConfig other = (PluginConfig)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append((Object)this.getPluginClass(), (Object)other.getPluginClass()).append((Object)this.getParametersAsString(), (Object)other.getParametersAsString()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getPluginClass()).append((Object)this.getParametersAsString()).toHashCode();
    }
}

