/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import javax.servlet.http.HttpServletRequest;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.TransactionAwareEventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.NodeProvisionException;
import org.opennms.netmgt.provision.persist.NodeProvisionService;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.ModelAndView;

public class DefaultNodeProvisionService
implements NodeProvisionService {
    private EventForwarder m_eventForwarder;
    @Autowired
    private CategoryDao m_categoryDao;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private ForeignSourceRepository m_foreignSourceRepository;

    @Override
    public ModelAndView getModelAndView(HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("foreignSources", this.m_foreignSourceRepository.getForeignSources());
        modelAndView.addObject("requisitions", this.m_foreignSourceRepository.getRequisitions());
        modelAndView.addObject("categories", (Object)this.m_categoryDao.getAllCategoryNames());
        modelAndView.addObject("success", (Object)Boolean.parseBoolean(request.getParameter("success")));
        modelAndView.addObject("foreignSource", (Object)request.getParameter("foreignSource"));
        return modelAndView;
    }

    @Override
    @Transactional
    public boolean provisionNode(String user, String foreignSource, String foreignId, String nodeLabel, String ipAddress, String[] categories, String snmpCommunity, String snmpVersion, String deviceUsername, String devicePassword, String enablePassword, String accessMethod, String autoEnable, String noSNMP) throws NodeProvisionException {
        if (this.log().isDebugEnabled()) {
            this.log().debug(String.format("adding SNMP community %s (%s)", snmpCommunity, snmpVersion));
        }
        if (noSNMP == null && snmpCommunity != null && !snmpCommunity.equals("") && snmpVersion != null && !snmpVersion.equals("")) {
            try {
                SnmpEventInfo info = new SnmpEventInfo();
                info.setCommunityString(snmpCommunity);
                info.setFirstIPAddress(ipAddress);
                info.setVersion(snmpVersion);
                this.m_snmpPeerFactory.define(info);
                SnmpPeerFactory.saveCurrent();
            }
            catch (Throwable e) {
                throw new NodeProvisionException("unable to add SNMP community information", e);
            }
        }
        this.log().debug("creating requisition node");
        RequisitionInterface reqIface = new RequisitionInterface();
        reqIface.setIpAddr(ipAddress);
        reqIface.setManaged(true);
        reqIface.setSnmpPrimary("P");
        reqIface.setStatus(1);
        reqIface.putMonitoredService(new RequisitionMonitoredService("ICMP"));
        if (noSNMP == null) {
            reqIface.putMonitoredService(new RequisitionMonitoredService("SNMP"));
        }
        RequisitionNode reqNode = new RequisitionNode();
        reqNode.setNodeLabel(nodeLabel);
        reqNode.setForeignId(foreignId);
        reqNode.putInterface(reqIface);
        for (String category : categories) {
            if (category == null || category.equals("")) continue;
            reqNode.putCategory(new RequisitionCategory(category));
        }
        if (deviceUsername != null && !deviceUsername.equals("")) {
            reqNode.putAsset(new RequisitionAsset("username", deviceUsername));
        }
        if (devicePassword != null && !devicePassword.equals("")) {
            reqNode.putAsset(new RequisitionAsset("password", devicePassword));
        }
        if (enablePassword != null && !enablePassword.equals("")) {
            reqNode.putAsset(new RequisitionAsset("enable", enablePassword));
        }
        if (accessMethod != null && !accessMethod.equals("")) {
            reqNode.putAsset(new RequisitionAsset("connection", accessMethod));
        }
        if (autoEnable != null) {
            reqNode.putAsset(new RequisitionAsset("autoenable", "A"));
        }
        try {
            Requisition req = this.m_foreignSourceRepository.getRequisition(foreignSource);
            req.putNode(reqNode);
            this.log().debug("saving requisition node");
            this.m_foreignSourceRepository.save(req);
        }
        catch (ForeignSourceRepositoryException e) {
            throw new RuntimeException("unable to retrieve foreign source '" + foreignSource + "'", (Throwable)((Object)e));
        }
        Event e = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "NodeProvisionService").addParam("url", this.m_foreignSourceRepository.getRequisitionURL(foreignSource).toString()).getEvent();
        this.m_eventForwarder.sendNow(e);
        this.log().warn("about to return (" + System.currentTimeMillis() + ")");
        return true;
    }

    public void setForeignSourceRepository(ForeignSourceRepository repository) {
        this.m_foreignSourceRepository = repository;
    }

    public void setEventProxy(final EventProxy proxy) throws Exception {
        EventForwarder proxyForwarder = new EventForwarder(){

            public void sendNow(Event event) {
                try {
                    proxy.send(event);
                }
                catch (EventProxyException e) {
                    throw new NodeProvisionException("Unable to send " + event, e);
                }
            }

            public void sendNow(Log eventLog) {
                try {
                    proxy.send(eventLog);
                }
                catch (EventProxyException e) {
                    throw new NodeProvisionException("Unable to send eventLog " + eventLog, e);
                }
            }
        };
        this.m_eventForwarder = new TransactionAwareEventForwarder(proxyForwarder);
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

