/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_monitoredServices", "m_categories"})
@XmlRootElement(name="interface")
public class RequisitionInterface
implements Comparable<RequisitionInterface> {
    @XmlElement(name="monitored-service")
    protected List<RequisitionMonitoredService> m_monitoredServices = new ArrayList<RequisitionMonitoredService>();
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlAttribute(name="descr")
    protected String m_description;
    @XmlAttribute(name="ip-addr", required=true)
    protected String m_ipAddress;
    @XmlAttribute(name="managed")
    protected Boolean m_isManaged;
    @XmlAttribute(name="snmp-primary")
    protected String m_snmpPrimary;
    @XmlAttribute(name="status")
    protected Integer m_status;

    @XmlTransient
    public int getMonitoredServiceCount() {
        return this.m_monitoredServices == null ? 0 : this.m_monitoredServices.size();
    }

    @XmlTransient
    public RequisitionMonitoredService[] getMonitoredService() {
        return this.getMonitoredServices().toArray(new RequisitionMonitoredService[0]);
    }

    public List<RequisitionMonitoredService> getMonitoredServices() {
        if (this.m_monitoredServices == null) {
            this.m_monitoredServices = new ArrayList<RequisitionMonitoredService>();
        }
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(List<RequisitionMonitoredService> services) {
        this.m_monitoredServices = services;
    }

    public RequisitionMonitoredService getMonitoredService(String service) {
        if (this.m_monitoredServices != null) {
            for (RequisitionMonitoredService svc : this.m_monitoredServices) {
                if (!svc.getServiceName().equals(service)) continue;
                return svc;
            }
        }
        return null;
    }

    public void deleteMonitoredService(RequisitionMonitoredService service) {
        this.m_monitoredServices.remove(service);
    }

    public void deleteMonitoredService(String service) {
        if (this.m_monitoredServices != null) {
            Iterator<RequisitionMonitoredService> i = this.m_monitoredServices.iterator();
            while (i.hasNext()) {
                RequisitionMonitoredService svc = i.next();
                if (!svc.getServiceName().equals(service)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertMonitoredService(RequisitionMonitoredService service) {
        Iterator<RequisitionMonitoredService> iterator = this.m_monitoredServices.iterator();
        while (iterator.hasNext()) {
            RequisitionMonitoredService existingService = iterator.next();
            if (!existingService.getServiceName().equals(service.getServiceName())) continue;
            iterator.remove();
        }
        this.m_monitoredServices.add(0, service);
    }

    public void putMonitoredService(RequisitionMonitoredService service) {
        Iterator<RequisitionMonitoredService> iterator = this.m_monitoredServices.iterator();
        while (iterator.hasNext()) {
            RequisitionMonitoredService existingService = iterator.next();
            if (!existingService.getServiceName().equals(service.getServiceName())) continue;
            iterator.remove();
        }
        this.m_monitoredServices.add(service);
    }

    public List<RequisitionCategory> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = new ArrayList<RequisitionCategory>();
        }
        return this.m_categories;
    }

    public void setCategories(List<RequisitionCategory> categories) {
        this.m_categories = categories;
    }

    public RequisitionCategory getCategory(String category) {
        if (this.m_categories != null) {
            for (RequisitionCategory cat : this.m_categories) {
                if (!cat.getName().equals(category)) continue;
                return cat;
            }
        }
        return null;
    }

    public void deleteCategory(RequisitionCategory category) {
        this.m_categories.remove(category);
    }

    public void deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                break;
            }
        }
    }

    public String getDescr() {
        return this.m_description;
    }

    public void setDescr(String value) {
        this.m_description = value;
    }

    public String getIpAddr() {
        return this.m_ipAddress;
    }

    public void setIpAddr(String value) {
        try {
            this.m_ipAddress = InetAddressUtils.toIpAddrString((InetAddress)InetAddressUtils.getInetAddress((String)value));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid IP address specified", e);
        }
    }

    public boolean isManaged() {
        if (this.m_isManaged == null) {
            return true;
        }
        return this.m_isManaged;
    }

    public void setManaged(Boolean value) {
        this.m_isManaged = value;
    }

    public String getSnmpPrimary() {
        return this.m_snmpPrimary;
    }

    public void setSnmpPrimary(String value) {
        this.m_snmpPrimary = value;
    }

    public int getStatus() {
        if (this.m_status == null) {
            return 1;
        }
        return this.m_status;
    }

    public void setStatus(Integer value) {
        this.m_status = value;
    }

    public boolean equals(Object o) {
        if (o instanceof RequisitionInterface) {
            return this.compareTo((RequisitionInterface)o) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(RequisitionInterface o) {
        return this.m_ipAddress.compareTo(o.getIpAddr());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("monitored-services", this.m_monitoredServices).append("categories", this.m_categories).append("description", (Object)this.m_description).append("ip-address", (Object)this.m_ipAddress).append("is-managed", (Object)this.m_isManaged).append("snmp-primary", (Object)this.m_snmpPrimary).append("status", (Object)this.m_status).toString();
    }
}

