/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsAssetRequisition;
import org.opennms.netmgt.provision.persist.OnmsIpInterfaceRequisition;
import org.opennms.netmgt.provision.persist.OnmsMonitoredServiceRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeCategoryRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;

public class OnmsNodeRequisition {
    private String m_foreignSource;
    private RequisitionNode m_node;
    private List<OnmsAssetRequisition> m_assetReqs;
    private List<OnmsIpInterfaceRequisition> m_ifaceReqs;
    private List<OnmsNodeCategoryRequisition> m_categoryReqs;

    public OnmsNodeRequisition(String foreignSource, RequisitionNode node) {
        this.m_foreignSource = foreignSource;
        this.m_node = node;
        this.m_assetReqs = this.constructAssetRequistions();
        this.m_ifaceReqs = this.constructIpInterfaceRequistions();
        this.m_categoryReqs = this.constructCategoryRequistions();
    }

    public String getForeignSource() {
        return this.m_foreignSource;
    }

    private List<OnmsAssetRequisition> constructAssetRequistions() {
        ArrayList<OnmsAssetRequisition> reqs = new ArrayList<OnmsAssetRequisition>(this.m_node.getAssets().size());
        for (RequisitionAsset asset : this.m_node.getAssets()) {
            reqs.add(new OnmsAssetRequisition(asset));
        }
        return reqs;
    }

    private List<OnmsIpInterfaceRequisition> constructIpInterfaceRequistions() {
        ArrayList<OnmsIpInterfaceRequisition> reqs = new ArrayList<OnmsIpInterfaceRequisition>(this.m_node.getInterfaces().size());
        for (RequisitionInterface iface : this.m_node.getInterfaces()) {
            reqs.add(new OnmsIpInterfaceRequisition(iface));
        }
        return reqs;
    }

    private List<OnmsNodeCategoryRequisition> constructCategoryRequistions() {
        ArrayList<OnmsNodeCategoryRequisition> reqs = new ArrayList<OnmsNodeCategoryRequisition>(this.m_node.getCategories().size());
        for (RequisitionCategory category : this.m_node.getCategories()) {
            reqs.add(new OnmsNodeCategoryRequisition(category));
        }
        return reqs;
    }

    public void visit(RequisitionVisitor visitor) {
        visitor.visitNode(this);
        for (OnmsNodeCategoryRequisition catReq : this.m_categoryReqs) {
            catReq.visit(visitor);
        }
        for (OnmsIpInterfaceRequisition ipReq : this.m_ifaceReqs) {
            ipReq.visit(visitor);
        }
        for (OnmsAssetRequisition assetReq : this.m_assetReqs) {
            assetReq.visit(visitor);
        }
        visitor.completeNode(this);
    }

    public OnmsNode constructOnmsNodeFromRequisition() {
        OnmsNodeBuilder visitor = new OnmsNodeBuilder();
        this.visit(visitor);
        return visitor.getNode();
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getNodeLabel() {
        return this.m_node.getNodeLabel();
    }

    public String getForeignId() {
        return this.m_node.getForeignId();
    }

    public String getBuilding() {
        return this.m_node.getBuilding();
    }

    public String getCity() {
        return this.m_node.getCity();
    }

    public String getParentForeignId() {
        return this.m_node.getParentForeignId();
    }

    public String getParentNodeLabel() {
        return this.m_node.getParentNodeLabel();
    }

    public RequisitionNode getNode() {
        return this.m_node;
    }

    private class OnmsNodeBuilder
    extends AbstractRequisitionVisitor {
        private NetworkBuilder bldr = new NetworkBuilder();

        private OnmsNodeBuilder() {
        }

        public OnmsNode getNode() {
            return this.bldr.getCurrentNode();
        }

        @Override
        public void visitAsset(OnmsAssetRequisition assetReq) {
            this.bldr.setAssetAttribute(assetReq.getName(), assetReq.getValue());
        }

        @Override
        public void visitNodeCategory(OnmsNodeCategoryRequisition catReq) {
            this.bldr.addCategory(catReq.getName());
        }

        @Override
        public void visitInterface(OnmsIpInterfaceRequisition ifaceReq) {
            String ipAddr = ifaceReq.getIpAddr();
            if (ipAddr == null || "".equals(ipAddr)) {
                this.bldr.clearInterface();
                String msg = String.format("Found interface on node %s with an empty ipaddr! Ignoring!", this.bldr.getCurrentNode().getLabel());
                OnmsNodeRequisition.this.log().error(msg);
                return;
            }
            NetworkBuilder.InterfaceBuilder ifBldr = this.bldr.addInterface(ipAddr);
            ifBldr.setIsManaged(ifaceReq.getStatus() == 3 ? "U" : "M");
            ifBldr.setIsSnmpPrimary(ifaceReq.getSnmpPrimary());
        }

        @Override
        public void visitMonitoredService(OnmsMonitoredServiceRequisition monSvcReq) {
            this.bldr.addService(monSvcReq.getServiceName());
        }

        @Override
        public void visitNode(OnmsNodeRequisition nodeReq) {
            NetworkBuilder.NodeBuilder nodeBldr = this.bldr.addNode(nodeReq.getNodeLabel());
            nodeBldr.setLabelSource("U");
            nodeBldr.setType("A");
            nodeBldr.setForeignSource(nodeReq.getForeignSource());
            nodeBldr.setForeignId(nodeReq.getForeignId());
            nodeBldr.getAssetRecord().setBuilding(nodeReq.getBuilding());
            nodeBldr.getAssetRecord().setCity(nodeReq.getCity());
        }
    }
}

