/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.netmgt.provision.persist.DirectoryWatcher;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class FasterFilesystemForeignSourceRepository
extends FilesystemForeignSourceRepository
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(FasterFilesystemForeignSourceRepository.class);
    private DirectoryWatcher<ForeignSource> m_foreignSources;
    private DirectoryWatcher<Requisition> m_requisitions;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.m_foreignSources = new DirectoryWatcher<ForeignSource>(new File(this.m_foreignSourcePath), FasterFilesystemForeignSourceRepository.fsLoader());
        this.m_requisitions = new DirectoryWatcher<Requisition>(new File(this.m_requisitionPath), FasterFilesystemForeignSourceRepository.reqLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.m_readLock.lock();
        try {
            LinkedHashSet<String> activeForeignSourceNames = new LinkedHashSet<String>();
            activeForeignSourceNames.addAll(this.m_foreignSources.getBaseNamesWithExtension(".xml"));
            activeForeignSourceNames.addAll(this.m_requisitions.getBaseNamesWithExtension(".xml"));
            LinkedHashSet<String> linkedHashSet = activeForeignSourceNames;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            int n = this.m_foreignSources.getBaseNamesWithExtension(".xml").size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            LinkedHashSet<ForeignSource> foreignSources = new LinkedHashSet<ForeignSource>();
            for (String baseName : this.m_foreignSources.getBaseNamesWithExtension(".xml")) {
                try {
                    ForeignSource contents = this.m_foreignSources.getContents(baseName + ".xml");
                    foreignSources.add(contents);
                }
                catch (FileNotFoundException e) {
                    LOG.info("Unable to load foreignSource {}: It must have been deleted by another thread", (Object)baseName, (Object)e);
                }
            }
            LinkedHashSet<ForeignSource> linkedHashSet = foreignSources;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        this.m_readLock.lock();
        try {
            ForeignSource foreignSource = this.m_foreignSources.getContents(foreignSourceName + ".xml");
            return foreignSource;
        }
        catch (FileNotFoundException e) {
            ForeignSource fs = this.getDefaultForeignSource();
            fs.setName(foreignSourceName);
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            LinkedHashSet<Requisition> requisitions = new LinkedHashSet<Requisition>();
            for (String baseName : this.m_requisitions.getBaseNamesWithExtension(".xml")) {
                try {
                    Requisition contents = this.m_requisitions.getContents(baseName + ".xml");
                    requisitions.add(contents);
                }
                catch (FileNotFoundException e) {
                    LOG.info("Unable to load requisition {}: It must have been deleted by another thread", (Object)baseName, (Object)e);
                }
            }
            LinkedHashSet<Requisition> linkedHashSet = requisitions;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.m_requisitions.getContents(foreignSourceName + ".xml");
            return requisition;
        }
        catch (FileNotFoundException e) {
            throw new ForeignSourceRepositoryException("Requisition: " + foreignSourceName + " does not exist.", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource);
            if (requisition == null) {
                URL uRL = null;
                return uRL;
            }
            URL uRL = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition).toURI().toURL();
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private static FileReloadCallback<ForeignSource> fsLoader() {
        return new FileReloadCallback<ForeignSource>(){

            public ForeignSource reload(ForeignSource object, Resource resource) throws IOException {
                return RequisitionFileUtils.getForeignSourceFromFile(resource.getFile());
            }
        };
    }

    private static FileReloadCallback<Requisition> reqLoader() {
        return new FileReloadCallback<Requisition>(){

            public Requisition reload(Requisition object, Resource resource) throws IOException {
                return RequisitionFileUtils.getRequisitionFromFile(resource.getFile());
            }
        };
    }
}

