/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.provision.persist.policies.MatchingIpInterfacePolicy;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class InterfacePolicyTest
implements InitializingBean {
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private DatabasePopulator m_populator;
    private List<OnmsIpInterface> m_interfaces;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_populator.populateDatabase();
        this.m_interfaces = this.m_ipInterfaceDao.findAll();
    }

    @Test
    @Transactional
    public void testMatchingPolicy() {
        OnmsIpInterface o = null;
        MatchingIpInterfacePolicy p = new MatchingIpInterfacePolicy();
        p.setAction("DO_NOT_PERSIST");
        p.setMatchBehavior("NO_PARAMETERS");
        p.setIpAddress("~^10\\..*$");
        ArrayList<OnmsIpInterface> populatedInterfaces = new ArrayList<OnmsIpInterface>();
        ArrayList<OnmsIpInterface> matchedInterfaces = new ArrayList<OnmsIpInterface>();
        for (OnmsIpInterface iface : this.m_interfaces) {
            InetAddress addr;
            System.err.println(iface);
            o = (OnmsIpInterface)p.apply((Object)iface);
            if (o != null) {
                matchedInterfaces.add(o);
            }
            if (!InetAddressUtils.str((InetAddress)(addr = iface.getIpAddress())).startsWith("10.")) continue;
            populatedInterfaces.add(iface);
        }
        Assert.assertEquals(populatedInterfaces, matchedInterfaces);
    }
}

