/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.provision.persist.PrimaryTypeAdapter;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="", propOrder={"m_monitoredServices", "m_categories"})
@XmlRootElement(name="interface")
public class RequisitionInterface
implements Comparable<RequisitionInterface> {
    @XmlElement(name="monitored-service")
    protected List<RequisitionMonitoredService> m_monitoredServices = new ArrayList<RequisitionMonitoredService>();
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlAttribute(name="descr")
    protected String m_description;
    @XmlAttribute(name="ip-addr", required=true)
    protected String m_ipAddress;
    @XmlAttribute(name="managed")
    protected Boolean m_isManaged;
    protected PrimaryType m_snmpPrimary;
    @XmlAttribute(name="status")
    protected Integer m_status;

    @XmlTransient
    public int getMonitoredServiceCount() {
        return this.m_monitoredServices == null ? 0 : this.m_monitoredServices.size();
    }

    @XmlTransient
    public RequisitionMonitoredService[] getMonitoredService() {
        return this.getMonitoredServices().toArray(new RequisitionMonitoredService[0]);
    }

    public List<RequisitionMonitoredService> getMonitoredServices() {
        if (this.m_monitoredServices == null) {
            this.m_monitoredServices = new ArrayList<RequisitionMonitoredService>();
        }
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(List<RequisitionMonitoredService> services) {
        this.m_monitoredServices = services;
    }

    public RequisitionMonitoredService getMonitoredService(String service) {
        if (this.m_monitoredServices != null) {
            for (RequisitionMonitoredService svc : this.m_monitoredServices) {
                if (!svc.getServiceName().equals(service)) continue;
                return svc;
            }
        }
        return null;
    }

    public void deleteMonitoredService(RequisitionMonitoredService service) {
        this.m_monitoredServices.remove(service);
    }

    public void deleteMonitoredService(String service) {
        if (this.m_monitoredServices != null) {
            Iterator<RequisitionMonitoredService> i = this.m_monitoredServices.iterator();
            while (i.hasNext()) {
                RequisitionMonitoredService svc = i.next();
                if (!svc.getServiceName().equals(service)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertMonitoredService(RequisitionMonitoredService service) {
        Iterator<RequisitionMonitoredService> iterator = this.m_monitoredServices.iterator();
        while (iterator.hasNext()) {
            RequisitionMonitoredService existingService = iterator.next();
            if (!existingService.getServiceName().equals(service.getServiceName())) continue;
            iterator.remove();
        }
        this.m_monitoredServices.add(0, service);
    }

    public void putMonitoredService(RequisitionMonitoredService service) {
        Iterator<RequisitionMonitoredService> iterator = this.m_monitoredServices.iterator();
        while (iterator.hasNext()) {
            RequisitionMonitoredService existingService = iterator.next();
            if (!existingService.getServiceName().equals(service.getServiceName())) continue;
            iterator.remove();
        }
        this.m_monitoredServices.add(service);
    }

    public List<RequisitionCategory> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = new ArrayList<RequisitionCategory>();
        }
        return this.m_categories;
    }

    public void setCategories(List<RequisitionCategory> categories) {
        this.m_categories = categories;
    }

    public RequisitionCategory getCategory(String category) {
        if (this.m_categories != null) {
            for (RequisitionCategory cat : this.m_categories) {
                if (!cat.getName().equals(category)) continue;
                return cat;
            }
        }
        return null;
    }

    public void deleteCategory(RequisitionCategory category) {
        this.m_categories.remove(category);
    }

    public void deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                break;
            }
        }
    }

    public String getDescr() {
        return this.m_description;
    }

    public void setDescr(String value) {
        this.m_description = value;
    }

    public String getIpAddr() {
        return this.m_ipAddress;
    }

    public void setIpAddr(String value) {
        try {
            this.m_ipAddress = InetAddressUtils.toIpAddrString((InetAddress)InetAddressUtils.getInetAddress((String)value));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid IP address specified", e);
        }
    }

    public boolean isManaged() {
        if (this.m_isManaged == null) {
            return true;
        }
        return this.m_isManaged;
    }

    public void setManaged(Boolean value) {
        this.m_isManaged = value;
    }

    @XmlAttribute(name="snmp-primary")
    @XmlJavaTypeAdapter(value=PrimaryTypeAdapter.class)
    public PrimaryType getSnmpPrimary() {
        if (this.m_snmpPrimary == null) {
            return PrimaryType.NOT_ELIGIBLE;
        }
        return this.m_snmpPrimary;
    }

    public void setSnmpPrimary(PrimaryType value) {
        this.m_snmpPrimary = value;
    }

    public Integer getStatus() {
        if (this.m_status == null) {
            return 1;
        }
        return this.m_status;
    }

    public void setStatus(Integer value) {
        this.m_status = value;
    }

    public int hashCode() {
        int prime = 67;
        int result = 1;
        result = 67 * result + (this.m_categories == null ? 0 : ((Object)this.m_categories).hashCode());
        result = 67 * result + (this.m_description == null ? 0 : this.m_description.hashCode());
        result = 67 * result + (this.m_ipAddress == null ? 0 : this.m_ipAddress.hashCode());
        result = 67 * result + (this.m_isManaged == null ? 0 : this.m_isManaged.hashCode());
        result = 67 * result + (this.m_monitoredServices == null ? 0 : ((Object)this.m_monitoredServices).hashCode());
        result = 67 * result + (this.m_snmpPrimary == null ? 0 : this.m_snmpPrimary.hashCode());
        result = 67 * result + (this.m_status == null ? 0 : this.m_status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequisitionInterface)) {
            return false;
        }
        RequisitionInterface other = (RequisitionInterface)obj;
        if (this.m_categories == null ? other.m_categories != null : !((Object)this.m_categories).equals(other.m_categories)) {
            return false;
        }
        if (this.m_description == null ? other.m_description != null : !this.m_description.equals(other.m_description)) {
            return false;
        }
        if (this.m_ipAddress == null ? other.m_ipAddress != null : !this.m_ipAddress.equals(other.m_ipAddress)) {
            return false;
        }
        if (this.m_isManaged == null ? other.m_isManaged != null : !this.m_isManaged.equals(other.m_isManaged)) {
            return false;
        }
        if (this.m_monitoredServices == null ? other.m_monitoredServices != null : !((Object)this.m_monitoredServices).equals(other.m_monitoredServices)) {
            return false;
        }
        if (this.m_snmpPrimary == null ? other.m_snmpPrimary != null : !this.getSnmpPrimary().equals((Object)other.getSnmpPrimary())) {
            return false;
        }
        return !(this.m_status == null ? other.m_status != null : !this.m_status.equals(other.m_status));
    }

    public String toString() {
        return "RequisitionInterface [monitoredServices=" + this.m_monitoredServices + ", categories=" + this.m_categories + ", description=" + this.m_description + ", ipAddress=" + this.m_ipAddress + ", isManaged=" + this.m_isManaged + ", snmpPrimary=" + this.m_snmpPrimary + ", status=" + this.m_status + "]";
    }

    @Override
    public int compareTo(RequisitionInterface other) {
        return new CompareToBuilder().append((Object)this.m_ipAddress, (Object)other.m_ipAddress).append((Object)this.m_status, (Object)other.m_status).append((Object)this.m_isManaged, (Object)other.m_isManaged).append((Object)this.getSnmpPrimary(), (Object)other.getSnmpPrimary()).append(this.m_monitoredServices, other.m_monitoredServices).append(this.m_categories, other.m_categories).append((Object)this.m_description, (Object)other.m_description).toComparison();
    }
}

