/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.foreignsource;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.provision.persist.foreignsource.PluginParameter;
import org.opennms.netmgt.provision.support.PluginWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="plugin")
public class PluginConfig
implements Serializable,
Comparable<PluginConfig> {
    private static final long serialVersionUID = 4307231598310473690L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="class")
    private String m_pluginClass;
    @XmlElement(name="parameter")
    private Set<PluginParameter> m_parameters = new LinkedHashSet<PluginParameter>();

    public PluginConfig() {
    }

    public PluginConfig(String name, String clazz) {
        this.setName(name);
        this.setPluginClass(clazz);
    }

    public PluginConfig(PluginConfig pluginConfig) {
        this.setName(pluginConfig.getName());
        this.setPluginClass(pluginConfig.getPluginClass());
        this.setParameterMap(pluginConfig.getParameterMap());
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPluginClass() {
        return this.m_pluginClass;
    }

    public void setPluginClass(String clazz) {
        this.m_pluginClass = clazz;
    }

    public Set<PluginParameter> getParameters() {
        for (PluginParameter p : this.m_parameters) {
            p.setPluginConfig(this);
        }
        return this.m_parameters;
    }

    public void setParameters(Set<PluginParameter> list) {
        for (PluginParameter p : list) {
            p.setPluginConfig(this);
        }
        this.m_parameters = list;
    }

    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> parms = new LinkedHashMap<String, String>();
        for (PluginParameter p : this.getParameters()) {
            parms.put(p.getKey(), p.getValue());
        }
        return Collections.unmodifiableMap(parms);
    }

    public void setParameterMap(Map<String, String> parameters) {
        this.m_parameters.clear();
        for (Map.Entry<String, String> set : parameters.entrySet()) {
            this.m_parameters.add(new PluginParameter(this, set));
        }
    }

    public String getParameter(String key) {
        for (PluginParameter p : this.getParameters()) {
            if (!p.getKey().equals(key)) continue;
            return p.getValue();
        }
        return null;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.add(new PluginParameter(this, key, value));
    }

    public void deleteParameters(PluginParameter p) {
        this.m_parameters.remove(p);
    }

    public Set<String> getAvailableParameterKeys() {
        Set<String> keys = new TreeSet<String>();
        try {
            PluginWrapper pw = new PluginWrapper(this.m_pluginClass);
            keys = pw.getOptionalKeys();
            for (PluginParameter p : this.getParameters()) {
                keys.remove(p.getKey());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return keys;
    }

    private String getParametersAsString() {
        StringBuilder sb = new StringBuilder();
        for (PluginParameter p : this.getParameters()) {
            sb.append(p.getKey()).append('=').append(p.getValue()).append('/');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 107;
        int result = 1;
        result = 107 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 107 * result + (this.m_pluginClass == null ? 0 : this.m_pluginClass.hashCode());
        result = 107 * result + (this.m_parameters == null ? 0 : ((Object)this.m_parameters).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginConfig)) {
            return false;
        }
        PluginConfig other = (PluginConfig)obj;
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        if (this.m_pluginClass == null ? other.m_pluginClass != null : !this.m_pluginClass.equals(other.m_pluginClass)) {
            return false;
        }
        return !(this.m_parameters == null ? other.m_parameters != null : !((Object)this.m_parameters).equals(other.m_parameters));
    }

    public String toString() {
        return "PluginConfig [name=" + this.m_name + ", pluginClass=" + this.m_pluginClass + ", parameters=" + this.getParametersAsString() + "]";
    }

    @Override
    public int compareTo(PluginConfig other) {
        return new CompareToBuilder().append((Object)this.m_name, (Object)other.m_name).append((Object)this.m_pluginClass, (Object)other.m_pluginClass).toComparison();
    }
}

