/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class RequisitionFileUtils {
    static void createPath(File fsPath) throws ForeignSourceRepositoryException {
        if (!fsPath.exists() && !fsPath.mkdirs()) {
            throw new ForeignSourceRepositoryException("unable to create directory " + fsPath.getPath());
        }
    }

    static File encodeFileName(String path, String foreignSourceName) {
        return new File(path, foreignSourceName + ".xml");
    }

    static ForeignSource getForeignSourceFromFile(File inputFile) throws ForeignSourceRepositoryException {
        return (ForeignSource)JaxbUtils.unmarshal(ForeignSource.class, (File)inputFile);
    }

    static Requisition getRequisitionFromFile(File inputFile) throws ForeignSourceRepositoryException {
        try {
            return (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)inputFile);
        }
        catch (Throwable e) {
            throw new ForeignSourceRepositoryException("unable to unmarshal " + inputFile.getPath(), e);
        }
    }

    static File getOutputFileForForeignSource(String path, ForeignSource foreignSource) {
        File fsPath = new File(path);
        RequisitionFileUtils.createPath(fsPath);
        return RequisitionFileUtils.encodeFileName(path, foreignSource.getName());
    }

    public static File getOutputFileForRequisition(String path, Requisition requisition) {
        return RequisitionFileUtils.getOutputFileForRequisition(path, requisition.getForeignSource());
    }

    public static File getOutputFileForRequisition(String path, String foreignSource) {
        File reqPath = new File(path);
        RequisitionFileUtils.createPath(reqPath);
        return RequisitionFileUtils.encodeFileName(path, foreignSource);
    }

    public static File createSnapshot(ForeignSourceRepository repository, String foreignSource, Date date) {
        URL url = repository.getRequisitionURL(foreignSource);
        if (url == null) {
            LogUtils.warnf(RequisitionFileUtils.class, (String)"Unable to get requisition URL for foreign source %s", (Object[])new Object[]{foreignSource});
            return null;
        }
        String sourceFileName = url.getFile();
        if (sourceFileName == null) {
            LogUtils.warnf(RequisitionFileUtils.class, (String)"Trying to create snapshot for %s, but getFile() doesn't return a value", (Object[])new Object[]{url});
            return null;
        }
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            LogUtils.warnf(RequisitionFileUtils.class, (String)"Trying to create snapshot for %s, but %s does not exist.", (Object[])new Object[]{url, sourceFileName});
            return null;
        }
        String targetFileName = sourceFileName + '.' + date.getTime();
        File targetFile = new File(targetFileName);
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile, (boolean)true);
            return targetFile;
        }
        catch (IOException e) {
            LogUtils.warnf(RequisitionFileUtils.class, (Throwable)e, (String)"Failed to copy %s to %s", (Object[])new Object[]{sourceFileName, targetFileName});
            return null;
        }
    }

    public static List<File> findSnapshots(ForeignSourceRepository repository, String foreignSource) {
        ArrayList<File> files = new ArrayList<File>();
        URL url = null;
        try {
            url = repository.getRequisitionURL(foreignSource);
        }
        catch (ForeignSourceRepositoryException e) {
            LogUtils.debugf(RequisitionFileUtils.class, (Throwable)((Object)e), (String)"Can't find snapshots for %s, an exception occurred getting the requisition URL!", (Object[])new Object[]{foreignSource});
        }
        if (url != null) {
            String sourceFileName = null;
            try {
                sourceFileName = URLDecoder.decode(url.getFile(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LogUtils.warnf(RequisitionFileUtils.class, (Throwable)e, (String)"Failed to decode URL %s as a file.", (Object[])new Object[]{url.getFile()});
            }
            if (sourceFileName != null) {
                File sourceFile = new File(sourceFileName);
                File sourceDirectory = sourceFile.getParentFile();
                for (File entry : sourceDirectory.listFiles()) {
                    if (!RequisitionFileUtils.isSnapshot(foreignSource, entry)) continue;
                    files.add(entry);
                }
            }
        }
        return files;
    }

    private static boolean isSnapshot(String foreignSource, File entry) {
        return !entry.isDirectory() && entry.getName().matches(foreignSource + ".xml.\\d+");
    }

    public static void deleteResourceIfSnapshot(Requisition requisition) {
        Resource resource = requisition.getResource();
        if (resource == null) {
            return;
        }
        try {
            File resourceFile = resource.getFile();
            if (RequisitionFileUtils.isSnapshot(requisition.getForeignSource(), resourceFile)) {
                LogUtils.tracef(RequisitionFileUtils.class, (String)"Deleting %s", (Object[])new Object[]{resourceFile});
                if (!resourceFile.delete()) {
                    LogUtils.debugf(RequisitionFileUtils.class, (String)"Failed to delete %s", (Object[])new Object[]{resourceFile});
                }
            }
        }
        catch (IOException e) {
            LogUtils.debugf(RequisitionFileUtils.class, (Throwable)e, (String)"Resource %s can't be turned into a file, skipping snapshot delete detection.", (Object[])new Object[]{resource});
            return;
        }
    }

    public static void deleteSnapshotsOlderThan(ForeignSourceRepository repository, String foreignSource, Date date) {
        for (File snapshotFile : RequisitionFileUtils.findSnapshots(repository, foreignSource)) {
            if (RequisitionFileUtils.isNewer(snapshotFile, date)) continue;
            LogUtils.tracef(RequisitionFileUtils.class, (String)"Deleting %s", (Object[])new Object[]{snapshotFile});
            snapshotFile.delete();
        }
    }

    public static void deleteAllSnapshots(ForeignSourceRepository repository) {
        for (String foreignSource : repository.getActiveForeignSourceNames()) {
            List<File> snapshots = RequisitionFileUtils.findSnapshots(repository, foreignSource);
            for (File snapshot : snapshots) {
                LogUtils.tracef(RequisitionFileUtils.class, (String)"Deleting %s", (Object[])new Object[]{snapshot});
                snapshot.delete();
            }
        }
    }

    public static Requisition getLatestPendingOrSnapshotRequisition(ForeignSourceRepository foreignSourceRepository, String foreignSource) {
        Requisition newest = foreignSourceRepository.getRequisition(foreignSource);
        for (File snapshotFile : RequisitionFileUtils.findSnapshots(foreignSourceRepository, foreignSource)) {
            if (newest != null && !RequisitionFileUtils.isNewer(snapshotFile, newest.getDate())) continue;
            newest = (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)snapshotFile);
            newest.setResource((Resource)new FileSystemResource(snapshotFile));
        }
        return newest;
    }

    public static boolean isNewer(File snapshotFile, Date date) {
        String name = snapshotFile.getName();
        String timestamp = name.substring(name.lastIndexOf(".") + 1);
        Date snapshotDate = new Date(Long.valueOf(timestamp));
        boolean isNewer = snapshotDate.after(date);
        LogUtils.tracef(RequisitionFileUtils.class, (String)"snapshot date = %s, comparison date = %s, snapshot date %s newer than comparison date", (Object[])new Object[]{snapshotDate.getTime(), date.getTime(), isNewer ? "is" : "is not"});
        return isNewer;
    }
}

