/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class QueueingForeignSourceRepository
implements ForeignSourceRepository,
InitializingBean {
    private final ConcurrentMap<String, Requisition> m_pendingRequisitions = new ConcurrentHashMap<String, Requisition>();
    private final ConcurrentMap<String, ForeignSource> m_pendingForeignSources = new ConcurrentHashMap<String, ForeignSource>();
    ForeignSourceRepository m_repository = null;
    private ExecutorService m_executor = Executors.newSingleThreadExecutor();

    @Override
    public void flush() throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"flushing queue", (Object[])new Object[0]);
        final CountDownLatch latch = new CountDownLatch(1);
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Interrupted while waiting for ForeignSourceRepository flush.  Returning.", (Object[])new Object[0]);
            return;
        }
        LogUtils.debugf((Object)this, (String)"finished flushing queue", (Object[])new Object[0]);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_repository, (String)"No foreign source repository was set!");
    }

    public ForeignSourceRepository getForeignSourceRepository() {
        return this.m_repository;
    }

    public void setForeignSourceRepository(ForeignSourceRepository fsr) {
        this.m_repository = fsr;
    }

    @Override
    public Set<String> getActiveForeignSourceNames() {
        return this.m_repository.getActiveForeignSourceNames();
    }

    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        return this.getActiveForeignSourceNames().size();
    }

    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        return this.m_repository.getForeignSources();
    }

    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_repository.getForeignSource(foreignSourceName);
    }

    @Override
    public void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"Queueing save of foreign source %s", (Object[])new Object[]{foreignSource.getName()});
        this.m_pendingForeignSources.put(foreignSource.getName(), foreignSource);
        this.m_executor.execute(new QueuePersistRunnable());
    }

    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"Queueing delete of foreign source %s", (Object[])new Object[]{foreignSource.getName()});
        this.m_pendingForeignSources.put(foreignSource.getName(), new DeletedForeignSource(foreignSource));
        this.m_executor.execute(new QueuePersistRunnable());
    }

    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        return this.m_repository.getRequisitions();
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        return this.m_repository.getRequisition(foreignSourceName);
    }

    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        return this.m_repository.getRequisition(foreignSource);
    }

    @Override
    public Date getRequisitionDate(String foreignSource) {
        if (this.m_pendingRequisitions.containsKey(foreignSource)) {
            return ((Requisition)this.m_pendingRequisitions.get(foreignSource)).getDate();
        }
        return this.m_repository.getRequisitionDate(foreignSource);
    }

    @Override
    public URL getRequisitionURL(String foreignSource) {
        return this.m_repository.getRequisitionURL(foreignSource);
    }

    @Override
    public void save(Requisition requisition) throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"Queueing save of requisition %s (containing %d nodes)", (Object[])new Object[]{requisition.getForeignSource(), requisition.getNodeCount()});
        this.m_pendingRequisitions.put(requisition.getForeignSource(), requisition);
        this.m_executor.execute(new QueuePersistRunnable());
    }

    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"Queueing delete of requistion %s", (Object[])new Object[]{requisition.getForeignSource()});
        this.m_pendingRequisitions.put(requisition.getForeignSource(), new DeletedRequisition(requisition));
        this.m_executor.execute(new QueuePersistRunnable());
    }

    @Override
    public ForeignSource getDefaultForeignSource() throws ForeignSourceRepositoryException {
        return this.m_repository.getDefaultForeignSource();
    }

    @Override
    public void putDefaultForeignSource(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_repository.putDefaultForeignSource(foreignSource);
    }

    @Override
    public void resetDefaultForeignSource() throws ForeignSourceRepositoryException {
        this.m_repository.resetDefaultForeignSource();
    }

    @Override
    public Requisition importResourceRequisition(Resource resource) throws ForeignSourceRepositoryException {
        return this.m_repository.importResourceRequisition(resource);
    }

    @Override
    public OnmsNodeRequisition getNodeRequisition(String foreignSource, String foreignId) throws ForeignSourceRepositoryException {
        return this.m_repository.getNodeRequisition(foreignSource, foreignId);
    }

    @Override
    public void validate(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_repository.validate(foreignSource);
    }

    @Override
    public void validate(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_repository.validate(requisition);
    }

    private static final class DeletedRequisition
    extends Requisition {
        private static final long serialVersionUID = -19738304185310191L;
        private final Requisition m_requisition;

        public DeletedRequisition(Requisition requisition) {
            this.m_requisition = requisition;
            this.setForeignSource(requisition.getForeignSource());
        }

        public Requisition getOriginal() {
            return this.m_requisition;
        }
    }

    private static final class DeletedForeignSource
    extends ForeignSource {
        private static final long serialVersionUID = -1484921681168837826L;
        private final ForeignSource m_foreignSource;

        public DeletedForeignSource(ForeignSource foreignSource) {
            this.m_foreignSource = foreignSource;
            this.setName(foreignSource.getName());
        }

        public ForeignSource getOriginal() {
            return this.m_foreignSource;
        }
    }

    private final class QueuePersistRunnable
    implements Runnable {
        private final String m_prefix = ThreadCategory.getPrefix();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String prefix = ThreadCategory.getPrefix();
            try {
                String foreignSourceName;
                ThreadCategory.setPrefix((String)this.m_prefix);
                LogUtils.debugf((Object)this, (String)"persisting repository changes", (Object[])new Object[0]);
                Set foreignSources = QueueingForeignSourceRepository.this.m_pendingForeignSources.entrySet();
                Set requisitions = QueueingForeignSourceRepository.this.m_pendingRequisitions.entrySet();
                LogUtils.debugf((Object)this, (String)"* %d pending foreign sources", (Object[])new Object[]{QueueingForeignSourceRepository.this.m_pendingForeignSources.size()});
                LogUtils.debugf((Object)this, (String)"* %d pending requisitions", (Object[])new Object[]{QueueingForeignSourceRepository.this.m_pendingRequisitions.size()});
                for (Map.Entry entry : foreignSources) {
                    foreignSourceName = (String)entry.getKey();
                    ForeignSource foreignSource = (ForeignSource)entry.getValue();
                    if (foreignSource instanceof DeletedForeignSource) {
                        DeletedForeignSource deletedForeignSource = (DeletedForeignSource)foreignSource;
                        QueueingForeignSourceRepository.this.m_repository.delete(deletedForeignSource.getOriginal());
                    } else {
                        QueueingForeignSourceRepository.this.m_repository.save(foreignSource);
                    }
                    QueueingForeignSourceRepository.this.m_pendingForeignSources.remove(foreignSourceName, foreignSource);
                }
                for (Map.Entry entry : requisitions) {
                    foreignSourceName = (String)entry.getKey();
                    Requisition requisition = (Requisition)entry.getValue();
                    if (requisition instanceof DeletedRequisition) {
                        DeletedRequisition deletedRequisition = (DeletedRequisition)requisition;
                        QueueingForeignSourceRepository.this.m_repository.delete(deletedRequisition.getOriginal());
                    } else {
                        QueueingForeignSourceRepository.this.m_repository.save(requisition);
                    }
                    QueueingForeignSourceRepository.this.m_pendingRequisitions.remove(foreignSourceName, requisition);
                }
                LogUtils.debugf((Object)this, (String)"finished persisting repository changes", (Object[])new Object[0]);
            }
            finally {
                ThreadCategory.setPrefix((String)prefix);
            }
        }
    }
}

