/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FilesystemForeignSourceRepository
extends AbstractForeignSourceRepository
implements InitializingBean {
    private String m_requisitionPath;
    private String m_foreignSourcePath;
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_requisitionPath, (String)"Requisition path must not be empty.");
        Assert.notNull((Object)this.m_foreignSourcePath, (String)"Foreign source path must not be empty.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.m_readLock.lock();
        try {
            TreeSet<String> fsNames = new TreeSet<String>();
            File directory = new File(this.m_foreignSourcePath);
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            if ((directory = new File(this.m_requisitionPath)).exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            TreeSet<String> treeSet = fsNames;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            int n = this.getForeignSources().size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_foreignSourcePath);
            TreeSet<ForeignSource> foreignSources = new TreeSet<ForeignSource>();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    foreignSources.add(RequisitionFileUtils.getForeignSourceFromFile(file));
                }
            }
            TreeSet<ForeignSource> treeSet = foreignSources;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = RequisitionFileUtils.encodeFileName(this.m_foreignSourcePath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                ForeignSource foreignSource = RequisitionFileUtils.getForeignSourceFromFile(inputFile);
                return foreignSource;
            }
            ForeignSource fs = this.getDefaultForeignSource();
            fs.setName(foreignSourceName);
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't save a null foreign source!");
        }
        LogUtils.debugf((Object)this, (String)"Writing foreign source %s to %s", (Object[])new Object[]{foreignSource.getName(), this.m_foreignSourcePath});
        this.validate(foreignSource);
        this.m_writeLock.lock();
        try {
            if (foreignSource.getName().equals("default")) {
                this.putDefaultForeignSource(foreignSource);
                return;
            }
            File outputFile = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            FileOutputStream outputStream = null;
            OutputStreamWriter writer = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)foreignSource, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_writeLock.lock();
        try {
            LogUtils.debugf((Object)this, (String)"Deleting foreign source %s from %s (if necessary)", (Object[])new Object[]{foreignSource.getName(), this.m_foreignSourcePath});
            File deleteFile = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            if (deleteFile.exists() && !deleteFile.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete foreign source file " + deleteFile);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_requisitionPath);
            TreeSet<Requisition> requisitions = new TreeSet<Requisition>();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    try {
                        requisitions.add(RequisitionFileUtils.getRequisitionFromFile(file));
                    }
                    catch (ForeignSourceRepositoryException e) {
                        // empty catch block
                    }
                }
            }
            TreeSet<Requisition> treeSet = requisitions;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = RequisitionFileUtils.encodeFileName(this.m_requisitionPath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                Requisition requisition = RequisitionFileUtils.getRequisitionFromFile(inputFile);
                return requisition;
            }
            Requisition requisition = null;
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource.getName());
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't save a null requisition!");
        }
        LogUtils.debugf((Object)this, (String)"Writing requisition %s to %s", (Object[])new Object[]{requisition.getForeignSource(), this.m_requisitionPath});
        this.validate(requisition);
        this.m_writeLock.lock();
        try {
            File outputFile = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            OutputStreamWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)requisition, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't delete a null requisition!");
        }
        this.m_writeLock.lock();
        try {
            LogUtils.debugf((Object)this, (String)"Deleting requisition %s from %s (if necessary)", (Object[])new Object[]{requisition.getForeignSource(), this.m_requisitionPath});
            File fileToDelete = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            if (fileToDelete.exists()) {
                if (!fileToDelete.delete()) {
                    throw new ForeignSourceRepositoryException("Unable to delete requisition file " + fileToDelete);
                }
            } else {
                LogUtils.debugf((Object)this, (String)"File %s does not exist.", (Object[])new Object[]{fileToDelete});
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequisitionPath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_requisitionPath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignSourcePath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_foreignSourcePath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getRequisitionDate(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource);
            if (requisition == null) {
                Date date = null;
                return date;
            }
            Date date = requisition.getDate();
            return date;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            URL uRL = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, foreignSource).toURI().toURL();
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public void flush() throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"flush() called", (Object[])new Object[0]);
    }
}

