/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.FileReloadCallback;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.DirectoryWatcher;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FasterFilesystemForeignSourceRepository
extends AbstractForeignSourceRepository
implements InitializingBean {
    private String m_requisitionPath;
    private String m_foreignSourcePath;
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private DirectoryWatcher<ForeignSource> m_foreignSources;
    private DirectoryWatcher<Requisition> m_requisitions;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_requisitionPath, (String)"Requisition path must not be empty.");
        Assert.notNull((Object)this.m_foreignSourcePath, (String)"Foreign source path must not be empty.");
        this.m_foreignSources = new DirectoryWatcher<ForeignSource>(new File(this.m_foreignSourcePath), this.fsLoader());
        this.m_requisitions = new DirectoryWatcher<Requisition>(new File(this.m_requisitionPath), this.reqLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.m_readLock.lock();
        try {
            LinkedHashSet<String> activeForeignSourceNames = new LinkedHashSet<String>();
            activeForeignSourceNames.addAll(this.m_foreignSources.getBaseNamesWithExtension(".xml"));
            activeForeignSourceNames.addAll(this.m_requisitions.getBaseNamesWithExtension(".xml"));
            LinkedHashSet<String> linkedHashSet = activeForeignSourceNames;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            int n = this.m_foreignSources.getBaseNamesWithExtension(".xml").size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            LinkedHashSet<ForeignSource> foreignSources = new LinkedHashSet<ForeignSource>();
            for (String baseName : this.m_foreignSources.getBaseNamesWithExtension(".xml")) {
                try {
                    ForeignSource contents = this.m_foreignSources.getContents(baseName + ".xml");
                    foreignSources.add(contents);
                }
                catch (FileNotFoundException e) {
                    LogUtils.infof((Object)this, (Throwable)e, (String)"Unable to load foreignSource %s: It must have been deleted by another thread", (Object[])new Object[]{baseName});
                }
            }
            LinkedHashSet<ForeignSource> linkedHashSet = foreignSources;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        this.m_readLock.lock();
        try {
            ForeignSource foreignSource = this.m_foreignSources.getContents(foreignSourceName + ".xml");
            return foreignSource;
        }
        catch (FileNotFoundException e) {
            ForeignSource fs = this.getDefaultForeignSource();
            fs.setName(foreignSourceName);
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't save a null foreign source!");
        }
        LogUtils.debugf((Object)this, (String)"Writing foreign source %s to %s", (Object[])new Object[]{foreignSource.getName(), this.m_foreignSourcePath});
        this.validate(foreignSource);
        this.m_writeLock.lock();
        try {
            if (foreignSource.getName().equals("default")) {
                this.putDefaultForeignSource(foreignSource);
                return;
            }
            File outputFile = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            FileOutputStream outputStream = null;
            OutputStreamWriter writer = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)foreignSource, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_writeLock.lock();
        try {
            LogUtils.debugf((Object)this, (String)"Deleting foreign source %s from %s (if necessary)", (Object[])new Object[]{foreignSource.getName(), this.m_foreignSourcePath});
            File deleteFile = RequisitionFileUtils.getOutputFileForForeignSource(this.m_foreignSourcePath, foreignSource);
            if (deleteFile.exists() && !deleteFile.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete foreign source file " + deleteFile);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            LinkedHashSet<Requisition> requisitions = new LinkedHashSet<Requisition>();
            for (String baseName : this.m_requisitions.getBaseNamesWithExtension(".xml")) {
                try {
                    Requisition contents = this.m_requisitions.getContents(baseName + ".xml");
                    requisitions.add(contents);
                }
                catch (FileNotFoundException e) {
                    LogUtils.infof((Object)this, (Throwable)e, (String)"Unable to load requisition %s: It must have been deleted by another thread", (Object[])new Object[]{baseName});
                }
            }
            LinkedHashSet<Requisition> linkedHashSet = requisitions;
            return linkedHashSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.m_requisitions.getContents(foreignSourceName + ".xml");
            return requisition;
        }
        catch (FileNotFoundException e) {
            throw new ForeignSourceRepositoryException("Requisition: " + foreignSourceName + " does not exist.", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource.getName());
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't save a null requisition!");
        }
        LogUtils.debugf((Object)this, (String)"Writing requisition %s to %s", (Object[])new Object[]{requisition.getForeignSource(), this.m_requisitionPath});
        this.validate(requisition);
        this.m_writeLock.lock();
        try {
            File outputFile = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            OutputStreamWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)requisition, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't delete a null requisition!");
        }
        this.m_writeLock.lock();
        try {
            LogUtils.debugf((Object)this, (String)"Deleting requisition %s from %s (if necessary)", (Object[])new Object[]{requisition.getForeignSource(), this.m_requisitionPath});
            File deleteFile = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition);
            if (deleteFile.exists() && !deleteFile.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete requisition file " + deleteFile);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequisitionPath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_requisitionPath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignSourcePath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_foreignSourcePath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getRequisitionDate(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource);
            if (requisition == null) {
                Date date = null;
                return date;
            }
            Date date = requisition.getDate();
            return date;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource);
            if (requisition == null) {
                URL uRL = null;
                return uRL;
            }
            URL uRL = RequisitionFileUtils.getOutputFileForRequisition(this.m_requisitionPath, requisition).toURI().toURL();
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public void flush() throws ForeignSourceRepositoryException {
        LogUtils.debugf((Object)this, (String)"flush() called", (Object[])new Object[0]);
    }

    private FileReloadCallback<ForeignSource> fsLoader() {
        return new FileReloadCallback<ForeignSource>(){

            public ForeignSource reload(ForeignSource object, Resource resource) throws IOException {
                return RequisitionFileUtils.getForeignSourceFromFile(resource.getFile());
            }
        };
    }

    private FileReloadCallback<Requisition> reqLoader() {
        return new FileReloadCallback<Requisition>(){

            public Requisition reload(Requisition object, Resource resource) throws IOException {
                return RequisitionFileUtils.getRequisitionFromFile(resource.getFile());
            }
        };
    }
}

