/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.core.utils.FileReloadCallback;
import org.opennms.core.utils.FileReloadContainer;

public class DirectoryWatcher<T> {
    private File m_directory;
    private FileReloadCallback<T> m_loader;
    private ConcurrentHashMap<String, FileReloadContainer<T>> m_contents = new ConcurrentHashMap();
    private AtomicReference<Set<String>> m_fileNames = new AtomicReference();

    public DirectoryWatcher(File directory, FileReloadCallback<T> loader) {
        this.m_directory = directory;
        this.m_directory.mkdirs();
        this.m_loader = loader;
    }

    public Set<String> getFileNames() {
        return this.checkFileChanges();
    }

    private Set<String> checkFileChanges() {
        LinkedHashSet<String> fileNames;
        Set<String> oldFileNames;
        do {
            if (!(fileNames = new LinkedHashSet<String>(Arrays.asList(this.m_directory.list()))).equals(oldFileNames = this.m_fileNames.get())) continue;
            return fileNames;
        } while (!this.m_fileNames.compareAndSet(oldFileNames, fileNames));
        this.m_contents.clear();
        return fileNames;
    }

    public Set<String> getBaseNamesWithExtension(String extension) {
        Set<String> fileNames = this.checkFileChanges();
        LinkedHashSet<String> basenames = new LinkedHashSet<String>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith(extension)) continue;
            String basename = fileName.substring(0, fileName.length() - extension.length());
            basenames.add(basename);
        }
        return basenames;
    }

    public T getContents(String fileName) throws FileNotFoundException {
        this.checkFileChanges();
        File file = new File(this.m_directory, fileName);
        if (file.exists()) {
            FileReloadContainer newContainer = new FileReloadContainer(file, this.m_loader);
            newContainer.setReloadCheckInterval(0L);
            FileReloadContainer container = this.m_contents.putIfAbsent(file.getName(), newContainer);
            if (container == null) {
                container = newContainer;
            }
            return (T)container.getObject();
        }
        this.m_contents.remove(fileName);
        throw new FileNotFoundException("there is no file " + fileName + " in directory " + this.m_directory);
    }
}

