/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.beanutils.MethodUtils;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.PropertyPath;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.OnmsPolicy;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.support.PluginWrapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultForeignSourceService
implements ForeignSourceService,
InitializingBean {
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    private static Map<String, String> m_detectors;
    private static Map<String, String> m_policies;
    private static Map<String, PluginWrapper> m_wrappers;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Override
    public void setDeployedForeignSourceRepository(ForeignSourceRepository repo) {
        this.m_deployedForeignSourceRepository = repo;
    }

    @Override
    public void setPendingForeignSourceRepository(ForeignSourceRepository repo) {
        this.m_pendingForeignSourceRepository = repo;
    }

    @Override
    public Set<ForeignSource> getAllForeignSources() {
        TreeSet<ForeignSource> foreignSources = new TreeSet<ForeignSource>();
        foreignSources.addAll(this.m_pendingForeignSourceRepository.getForeignSources());
        for (ForeignSource fs : this.m_deployedForeignSourceRepository.getForeignSources()) {
            if (foreignSources.contains(fs)) continue;
            foreignSources.add(fs);
        }
        return foreignSources;
    }

    @Override
    public ForeignSource getForeignSource(String name) {
        ForeignSource fs = this.m_pendingForeignSourceRepository.getForeignSource(name);
        if (fs.isDefault()) {
            return this.m_deployedForeignSourceRepository.getForeignSource(name);
        }
        return fs;
    }

    @Override
    public ForeignSource saveForeignSource(String name, ForeignSource fs) {
        this.normalizePluginConfigs(fs);
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public void deleteForeignSource(String name) {
        if (name.equals("default")) {
            this.m_pendingForeignSourceRepository.resetDefaultForeignSource();
            this.m_deployedForeignSourceRepository.resetDefaultForeignSource();
        } else {
            ForeignSource fs = this.getForeignSource(name);
            this.m_pendingForeignSourceRepository.delete(fs);
            this.m_deployedForeignSourceRepository.delete(fs);
        }
    }

    @Override
    public ForeignSource cloneForeignSource(String name, String target) {
        ForeignSource fs = this.getForeignSource(name);
        fs.setDefault(false);
        fs.setName(target);
        this.m_deployedForeignSourceRepository.save(fs);
        this.m_pendingForeignSourceRepository.delete(fs);
        return this.m_deployedForeignSourceRepository.getForeignSource(target);
    }

    @Override
    public ForeignSource addParameter(String foreignSourceName, String pathToAdd) {
        ForeignSource fs = this.getForeignSource(foreignSourceName);
        PropertyPath path = new PropertyPath(pathToAdd);
        Object obj = path.getValue((Object)fs);
        try {
            MethodUtils.invokeMethod((Object)obj, (String)"addParameter", (Object[])new Object[]{"key", "value"});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to call addParameter on object of type " + obj.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to access property " + pathToAdd, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("an execption occurred adding a parameter to " + pathToAdd, e);
        }
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public ForeignSource deletePath(String foreignSourceName, String pathToDelete) {
        ForeignSource fs = this.getForeignSource(foreignSourceName);
        PropertyPath path = new PropertyPath(pathToDelete);
        Object objToDelete = path.getValue((Object)fs);
        ForeignSource parentObject = path.getParent() == null ? fs : path.getParent().getValue((Object)fs);
        String propName = path.getPropertyName();
        String methodSuffix = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
        String methodName = "delete" + methodSuffix;
        try {
            MethodUtils.invokeMethod((Object)parentObject, (String)methodName, (Object[])new Object[]{objToDelete});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find method " + methodName + " on object of type " + parentObject.getClass() + " with argument " + objToDelete, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to access property " + pathToDelete, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("an execption occurred deleting " + pathToDelete, e);
        }
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public ForeignSource addDetectorToForeignSource(String foreignSource, String name) {
        ForeignSource fs = this.getForeignSource(foreignSource);
        PluginConfig pc = new PluginConfig(name, "unknown");
        fs.addDetector(pc);
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public ForeignSource deleteDetector(String foreignSource, String name) {
        ForeignSource fs = this.getForeignSource(foreignSource);
        List<PluginConfig> detectors = fs.getDetectors();
        Iterator<PluginConfig> i = detectors.iterator();
        while (i.hasNext()) {
            PluginConfig pc = i.next();
            if (!pc.getName().equals(name)) continue;
            i.remove();
            break;
        }
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public ForeignSource addPolicyToForeignSource(String foreignSource, String name) {
        ForeignSource fs = this.getForeignSource(foreignSource);
        PluginConfig pc = new PluginConfig(name, "unknown");
        fs.addPolicy(pc);
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public ForeignSource deletePolicy(String foreignSource, String name) {
        ForeignSource fs = this.getForeignSource(foreignSource);
        List<PluginConfig> policies = fs.getPolicies();
        Iterator<PluginConfig> i = policies.iterator();
        while (i.hasNext()) {
            PluginConfig pc = i.next();
            if (!pc.getName().equals(name)) continue;
            i.remove();
            break;
        }
        this.m_pendingForeignSourceRepository.save(fs);
        return fs;
    }

    @Override
    public Map<String, String> getDetectorTypes() {
        if (m_detectors == null) {
            TreeMap<String, String> detectors = new TreeMap<String, String>();
            for (ServiceDetector serviceDetector : this.m_serviceRegistry.findProviders(ServiceDetector.class)) {
                String serviceName = serviceDetector.getServiceName();
                if (serviceName == null) {
                    serviceName = serviceDetector.getClass().getSimpleName();
                }
                detectors.put(serviceName, serviceDetector.getClass().getName());
            }
            m_detectors = new LinkedHashMap<String, String>();
            for (Map.Entry entry : detectors.entrySet()) {
                m_detectors.put((String)entry.getValue(), (String)entry.getKey());
            }
        }
        return m_detectors;
    }

    @Override
    public Map<String, String> getPolicyTypes() {
        if (m_policies == null) {
            TreeMap<String, String> policies = new TreeMap<String, String>();
            for (OnmsPolicy onmsPolicy : this.m_serviceRegistry.findProviders(OnmsPolicy.class)) {
                Policy annotation;
                String policyName = onmsPolicy.getClass().getSimpleName();
                if (onmsPolicy.getClass().isAnnotationPresent(Policy.class) && (annotation = onmsPolicy.getClass().getAnnotation(Policy.class)).value() != null && annotation.value().length() > 0) {
                    policyName = annotation.value();
                }
                policies.put(policyName, onmsPolicy.getClass().getName());
            }
            m_policies = new LinkedHashMap<String, String>();
            for (Map.Entry entry : policies.entrySet()) {
                m_policies.put((String)entry.getValue(), (String)entry.getKey());
            }
        }
        return m_policies;
    }

    @Override
    public Map<String, PluginWrapper> getWrappers() {
        if (m_wrappers == null && m_policies != null && m_detectors != null) {
            PluginWrapper wrapper;
            m_wrappers = new HashMap<String, PluginWrapper>(m_policies.size());
            for (String key : m_policies.keySet()) {
                try {
                    wrapper = new PluginWrapper(key);
                    m_wrappers.put(key, wrapper);
                }
                catch (Throwable e) {
                    this.log().warn("unable to wrap " + key, e);
                }
            }
            for (String key : m_detectors.keySet()) {
                try {
                    wrapper = new PluginWrapper(key);
                    m_wrappers.put(key, wrapper);
                }
                catch (Throwable e) {
                    this.log().warn("unable to wrap " + key, e);
                }
            }
        }
        return m_wrappers;
    }

    private void normalizePluginConfigs(ForeignSource fs) {
        for (PluginConfig pc : fs.getDetectors()) {
            this.normalizePluginConfig(pc);
        }
        for (PluginConfig pc : fs.getPolicies()) {
            this.normalizePluginConfig(pc);
        }
    }

    private void normalizePluginConfig(PluginConfig pc) {
        PluginWrapper w;
        if (m_wrappers.containsKey(pc.getPluginClass()) && (w = m_wrappers.get(pc.getPluginClass())) != null) {
            Map<String, String> parameters = pc.getParameterMap();
            Map required = w.getRequiredItems();
            for (String key : required.keySet()) {
                String value = "";
                if (parameters.containsKey(key)) continue;
                if (((Set)required.get(key)).size() > 0) {
                    value = (String)((Set)required.get(key)).iterator().next();
                }
                pc.addParameter(key, value);
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(DefaultForeignSourceService.class);
    }
}

