/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.test.JUnitConfigurationEnvironment;

@JUnitConfigurationEnvironment
public class RequisitionFrom18Test {
    private FilesystemForeignSourceRepository m_foreignSourceRepository;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        this.m_foreignSourceRepository = new FilesystemForeignSourceRepository();
        this.m_foreignSourceRepository.setForeignSourcePath("target/test-classes/empty");
        this.m_foreignSourceRepository.setRequisitionPath("target/test-classes/1.8-upgrade-test");
    }

    @Test
    public void test18Requisitions() {
        Set requisitions = this.m_foreignSourceRepository.getRequisitions();
        Assert.assertEquals((long)11L, (long)requisitions.size());
        int nodeCount = 0;
        int interfaceCount = 0;
        for (Requisition r : requisitions) {
            LogUtils.debugf((Object)this, (String)"got requisition: %s", (Object[])new Object[]{r});
            nodeCount += r.getNodeCount();
            for (RequisitionNode node : r.getNode()) {
                interfaceCount += node.getInterfaceCount();
                if (!"pgvip-master.somemediathing.net".equals(node.getNodeLabel())) continue;
                Assert.assertEquals((Object)"postgres", (Object)node.getParentForeignSource());
                Assert.assertEquals((Object)"1241674181872", (Object)node.getParentForeignId());
                Assert.assertEquals((Object)"barbacoa.somemediathing.net", (Object)node.getParentNodeLabel());
            }
        }
        Assert.assertEquals((String)"There is an unexpected number of nodes in the test requisitions", (long)49L, (long)nodeCount);
        Assert.assertEquals((String)"There is an unexpected number of interfaces in the test requisitions", (long)60L, (long)interfaceCount);
    }
}

