/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.persist.FilesystemForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

public class RequisitionFileUtilsTest {
    private FilesystemForeignSourceRepository m_repository;

    @Before
    public void createTestRepository() throws Exception {
        File requisitionDirectory = new File("target/RequisitionFileUtilsTest");
        if (requisitionDirectory.exists()) {
            FileUtils.deleteDirectory((File)requisitionDirectory);
        }
        FilesystemForeignSourceRepository fsr = new FilesystemForeignSourceRepository();
        fsr.setForeignSourcePath("target/RequisitionFileUtilsTest/foreign-sources");
        fsr.setRequisitionPath("target/RequisitionFileUtilsTest/imports");
        fsr.afterPropertiesSet();
        fsr.save(new Requisition("test"));
        this.m_repository = fsr;
    }

    @Test
    public void testCreateTemporaryRequisition() throws Exception {
        File file = RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.getPath().contains("target/RequisitionFileUtilsTest/imports/test"));
        Assert.assertTrue((boolean)file.getPath().matches(".*target/RequisitionFileUtilsTest/imports/test.xml.\\d+"));
        List snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertNotNull((Object)snapshots);
        Assert.assertEquals((long)1L, (long)snapshots.size());
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Assert.assertEquals((long)2L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test").size());
        this.m_repository.save(new Requisition("test2"));
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test2", (Date)new Date());
        Assert.assertEquals((long)1L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test2").size());
        Assert.assertEquals((long)2L, (long)RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test").size());
    }

    @Test
    public void testDeleteSnapshots() throws Exception {
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Thread.sleep(1L);
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        Thread.sleep(1L);
        RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.m_repository, (String)"test", (Date)new Date());
        List snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertNotNull((Object)snapshots);
        Assert.assertEquals((long)3L, (long)snapshots.size());
        RequisitionFileUtils.deleteAllSnapshots((ForeignSourceRepository)this.m_repository);
        snapshots = RequisitionFileUtils.findSnapshots((ForeignSourceRepository)this.m_repository, (String)"test");
        Assert.assertEquals((long)0L, (long)snapshots.size());
    }
}

