/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_interfaces", "m_categories", "m_assets"})
@XmlRootElement(name="node")
public class RequisitionNode {
    @XmlElement(name="interface")
    protected List<RequisitionInterface> m_interfaces = new ArrayList<RequisitionInterface>();
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlElement(name="asset")
    protected List<RequisitionAsset> m_assets = new ArrayList<RequisitionAsset>();
    @XmlAttribute
    protected String building;
    @XmlAttribute
    protected String city;
    @XmlAttribute(name="foreign-id", required=true)
    protected String foreignId;
    @XmlAttribute(name="node-label", required=true)
    protected String nodeLabel;
    @XmlAttribute(name="parent-foreign-source")
    protected String parentForeignSource;
    @XmlAttribute(name="parent-foreign-id")
    protected String parentForeignId;
    @XmlAttribute(name="parent-node-label")
    protected String parentNodeLabel;

    @XmlTransient
    public int getInterfaceCount() {
        return this.m_interfaces == null ? 0 : this.m_interfaces.size();
    }

    @XmlTransient
    public RequisitionInterface[] getInterface() {
        return this.getInterfaces().toArray(new RequisitionInterface[0]);
    }

    public List<RequisitionInterface> getInterfaces() {
        return this.m_interfaces;
    }

    public void setInterfaces(Collection<RequisitionInterface> interfaces) {
        if (interfaces == null) {
            interfaces = new TreeSet<RequisitionInterface>();
        }
        this.m_interfaces.clear();
        this.m_interfaces.addAll(interfaces);
    }

    public RequisitionInterface getInterface(String ipAddress) {
        for (RequisitionInterface iface : this.m_interfaces) {
            if (!iface.getIpAddr().equals(ipAddress)) continue;
            return iface;
        }
        return null;
    }

    public void deleteInterface(RequisitionInterface iface) {
        this.m_interfaces.remove(iface);
    }

    public void deleteInterface(String ipAddress) {
        Iterator<RequisitionInterface> i = this.m_interfaces.iterator();
        while (i.hasNext()) {
            RequisitionInterface iface = i.next();
            if (!iface.getIpAddr().equals(ipAddress)) continue;
            i.remove();
            break;
        }
    }

    public void putInterface(RequisitionInterface iface) {
        this.m_interfaces.remove(iface);
        this.m_interfaces.add(0, iface);
    }

    @XmlTransient
    public int getCategoryCount() {
        return this.m_categories == null ? 0 : this.m_categories.size();
    }

    @XmlTransient
    public RequisitionCategory[] getCategory() {
        return this.m_categories.toArray(new RequisitionCategory[0]);
    }

    public List<RequisitionCategory> getCategories() {
        return this.m_categories;
    }

    public void setCategories(Collection<RequisitionCategory> categories) {
        if (categories == null) {
            categories = new TreeSet<RequisitionCategory>();
        }
        this.m_categories.clear();
        this.m_categories.addAll(categories);
    }

    public RequisitionCategory getCategory(String category) {
        for (RequisitionCategory cat : this.m_categories) {
            if (!cat.getName().equals(category)) continue;
            return cat;
        }
        return null;
    }

    public void deleteCategory(RequisitionCategory category) {
        this.m_categories.remove(category);
    }

    public void deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                break;
            }
        }
    }

    public void putCategory(RequisitionCategory category) {
        this.m_categories.remove(category);
        this.m_categories.add(0, category);
    }

    @XmlTransient
    public int getAssetCount() {
        return this.m_assets == null ? 0 : this.m_assets.size();
    }

    @XmlTransient
    public RequisitionAsset[] getAsset() {
        return this.m_assets.toArray(new RequisitionAsset[0]);
    }

    public List<RequisitionAsset> getAssets() {
        return this.m_assets;
    }

    public void setAssets(Collection<RequisitionAsset> assets) {
        if (assets == null) {
            assets = new TreeSet<RequisitionAsset>();
        }
        this.m_assets.clear();
        this.m_assets.addAll(assets);
    }

    public RequisitionAsset getAsset(String name) {
        for (RequisitionAsset asset : this.m_assets) {
            if (!asset.getName().equals(name)) continue;
            return asset;
        }
        return null;
    }

    public void deleteAsset(String name) {
        Iterator<RequisitionAsset> i = this.m_assets.iterator();
        while (i.hasNext()) {
            RequisitionAsset asset = i.next();
            if (!asset.getName().equals(name)) continue;
            i.remove();
            break;
        }
    }

    public void deleteAsset(RequisitionAsset asset) {
        this.m_assets.remove(asset);
    }

    public void putAsset(RequisitionAsset asset) {
        this.m_assets.remove(asset);
        this.m_assets.add(0, asset);
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String value) {
        this.building = value;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String value) {
        this.city = value;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String value) {
        this.foreignId = value;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String value) {
        this.nodeLabel = value;
    }

    public String getParentForeignSource() {
        return this.parentForeignSource;
    }

    public void setParentForeignSource(String value) {
        this.parentForeignSource = value;
    }

    public String getParentForeignId() {
        return this.parentForeignId;
    }

    public void setParentForeignId(String value) {
        this.parentForeignId = value;
    }

    public String getParentNodeLabel() {
        return this.parentNodeLabel;
    }

    public void setParentNodeLabel(String value) {
        this.parentNodeLabel = value;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("interfaces", this.m_interfaces).append("categories", this.m_categories).append("assets", this.m_assets).append("building", (Object)this.building).append("city", (Object)this.city).append("foreign-id", (Object)this.foreignId).append("node-label", (Object)this.nodeLabel).append("parent-foreign-source", (Object)this.parentForeignSource).append("parent-foreign-id", (Object)this.parentForeignId).append("parent-node-label", (Object)this.parentNodeLabel).toString();
    }
}

