/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="model-import")
@ValidateUsing(value="model-import.xsd")
public class Requisition
implements Serializable,
Comparable<Requisition> {
    private static final long serialVersionUID = 2099710942679236239L;
    @XmlTransient
    private Map<String, OnmsNodeRequisition> m_nodeReqs = new LinkedHashMap<String, OnmsNodeRequisition>();
    @XmlElement(name="node")
    protected List<RequisitionNode> m_nodes = new ArrayList<RequisitionNode>();
    @XmlAttribute(name="date-stamp")
    protected XMLGregorianCalendar m_dateStamp;
    @XmlAttribute(name="foreign-source")
    protected String m_foreignSource = "imported:";
    @XmlAttribute(name="last-import")
    protected XMLGregorianCalendar m_lastImport;

    public RequisitionNode getNode(String foreignId) {
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                if (!n.getForeignId().equals(foreignId)) continue;
                LogUtils.debugf((Object)this, (String)"returning node '%s' for foreign id '%s'", (Object[])new Object[]{n, foreignId});
                return n;
            }
        }
        return null;
    }

    public void deleteNode(RequisitionNode node) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(node.getForeignId())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteNode(String foreignId) {
        if (this.m_nodes != null) {
            Iterator<RequisitionNode> i = this.m_nodes.iterator();
            while (i.hasNext()) {
                RequisitionNode n = i.next();
                if (!n.getForeignId().equals(foreignId)) continue;
                i.remove();
                break;
            }
        }
    }

    @XmlTransient
    public RequisitionNode[] getNode() {
        return this.getNodes().toArray(new RequisitionNode[0]);
    }

    public List<RequisitionNode> getNodes() {
        return this.m_nodes;
    }

    public void setNodes(List<RequisitionNode> nodes) {
        this.m_nodes = nodes;
        this.updateNodeCache();
    }

    public void insertNode(RequisitionNode node) {
        this.updateNodeCacheIfNecessary();
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(0, node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public void putNode(RequisitionNode node) {
        this.updateNodeCacheIfNecessary();
        if (this.m_nodeReqs.containsKey(node.getForeignId())) {
            RequisitionNode n = this.m_nodeReqs.get(node.getForeignId()).getNode();
            this.m_nodes.remove(n);
        }
        this.m_nodes.add(node);
        this.m_nodeReqs.put(node.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), node));
    }

    public XMLGregorianCalendar getDateStamp() {
        return this.m_dateStamp;
    }

    public void setDateStamp(XMLGregorianCalendar value) {
        this.m_dateStamp = value;
    }

    public void updateDateStamp() {
        try {
            this.m_dateStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to update datestamp", (Object[])new Object[0]);
        }
    }

    public String getForeignSource() {
        if (this.m_foreignSource == null) {
            return "imported:";
        }
        return this.m_foreignSource;
    }

    public void setForeignSource(String value) {
        this.m_foreignSource = value;
    }

    public XMLGregorianCalendar getLastImport() {
        return this.m_lastImport;
    }

    public void setLastImport(XMLGregorianCalendar value) {
        this.m_lastImport = value;
    }

    public void updateLastImported() {
        try {
            this.m_lastImport = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to update last import datestamp", (Object[])new Object[0]);
        }
    }

    @XmlAttribute(name="non-ip-interfaces")
    public boolean getNonIpInterfaces() {
        return false;
    }

    public void setNonIpInterfaces(boolean nii) {
    }

    @XmlAttribute(name="non-ip-snmp-primary")
    public String getNonIpSnmpPrimary() {
        return "N";
    }

    public void setNonIpSnmpPrimary(String nisp) {
    }

    public Requisition() {
        this.updateNodeCache();
        this.updateDateStamp();
    }

    public Requisition(String foreignSource) {
        this();
        this.m_foreignSource = foreignSource;
    }

    private void updateNodeCache() {
        this.m_nodeReqs.clear();
        if (this.m_nodes != null) {
            for (RequisitionNode n : this.m_nodes) {
                this.m_nodeReqs.put(n.getForeignId(), new OnmsNodeRequisition(this.getForeignSource(), n));
            }
        }
    }

    private void updateNodeCacheIfNecessary() {
        if (this.m_nodes != null && this.m_nodeReqs.size() != this.m_nodes.size()) {
            this.updateNodeCache();
        }
    }

    public void visit(RequisitionVisitor visitor) {
        this.updateNodeCacheIfNecessary();
        if (visitor == null) {
            LogUtils.warnf((Object)this, (String)"no visitor specified!", (Object[])new Object[0]);
            return;
        }
        visitor.visitModelImport(this);
        for (OnmsNodeRequisition nodeReq : this.m_nodeReqs.values()) {
            nodeReq.visit(visitor);
        }
        visitor.completeModelImport(this);
    }

    public OnmsNodeRequisition getNodeRequistion(String foreignId) {
        this.updateNodeCacheIfNecessary();
        return this.m_nodeReqs.get(foreignId);
    }

    @XmlTransient
    public int getNodeCount() {
        return this.m_nodes == null ? 0 : this.m_nodes.size();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("foreign-source", (Object)this.getForeignSource()).append("date-stamp", (Object)this.getDateStamp()).append("last-import", (Object)this.getLastImport()).append("nodes", this.getNodes()).toString();
    }

    @Override
    public int compareTo(Requisition obj) {
        return this.getForeignSource().compareTo(obj.getForeignSource());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Requisition) {
            Requisition other = (Requisition)obj;
            return this.getForeignSource().equals(other.getForeignSource());
        }
        return false;
    }

    public int hashCode() {
        return this.getForeignSource().hashCode();
    }

    public void validate() throws ValidationException {
        HashMap<String, Integer> foreignSourceCounts = new HashMap<String, Integer>();
        HashSet<String> errors = new HashSet<String>();
        for (RequisitionNode node : this.m_nodes) {
            int n;
            String foreignId = node.getForeignId();
            Integer count = (Integer)foreignSourceCounts.get(foreignId);
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            foreignSourceCounts.put(foreignId, n);
        }
        for (String foreignId : foreignSourceCounts.keySet()) {
            Integer count = (Integer)foreignSourceCounts.get(foreignId);
            if (count <= 1) continue;
            errors.add(foreignId + " (" + count + " found)");
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Duplicate nodes found on foreign source ").append(this.getForeignSource()).append(": ");
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                String error = (String)it.next();
                sb.append(error);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            throw new ValidationException(sb.toString());
        }
    }
}

