/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;

public class FilesystemForeignSourceRepository
extends AbstractForeignSourceRepository {
    private String m_requisitionPath;
    private String m_foreignSourcePath;
    private boolean m_updateDateStamps = true;
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getActiveForeignSourceNames() {
        this.m_readLock.lock();
        try {
            TreeSet<String> fsNames = new TreeSet<String>();
            File directory = new File(this.m_foreignSourcePath);
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            if ((directory = new File(this.m_requisitionPath)).exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    fsNames.add(file.getName().replaceAll(".xml$", ""));
                }
            }
            TreeSet<String> treeSet = fsNames;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateDateStamps(boolean update) {
        this.m_writeLock.lock();
        try {
            this.m_updateDateStamps = update;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getForeignSourceCount() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            int n = this.getForeignSources().size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ForeignSource> getForeignSources() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_foreignSourcePath);
            TreeSet<ForeignSource> foreignSources = new TreeSet<ForeignSource>();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    foreignSources.add(this.get(file));
                }
            }
            TreeSet<ForeignSource> treeSet = foreignSources;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForeignSource getForeignSource(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a foreign source with a null name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = this.encodeFileName(this.m_foreignSourcePath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                ForeignSource foreignSource = this.get(inputFile);
                return foreignSource;
            }
            ForeignSource fs = this.getDefaultForeignSource();
            fs.setName(foreignSourceName);
            ForeignSource foreignSource = fs;
            return foreignSource;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't save a null foreign source!");
        }
        this.m_writeLock.lock();
        try {
            if (foreignSource.getName().equals("default")) {
                this.putDefaultForeignSource(foreignSource);
                return;
            }
            File outputFile = this.getOutputFileForForeignSource(foreignSource);
            FileOutputStream outputStream = null;
            OutputStreamWriter writer = null;
            try {
                if (this.m_updateDateStamps) {
                    foreignSource.updateDateStamp();
                }
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)foreignSource, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_writeLock.lock();
        try {
            File deleteFile = this.getOutputFileForForeignSource(foreignSource);
            if (deleteFile.exists() && !deleteFile.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete foreign source file " + deleteFile);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            File directory = new File(this.m_requisitionPath);
            TreeSet<Requisition> requisitions = new TreeSet<Requisition>();
            if (directory.exists()) {
                for (File file : directory.listFiles()) {
                    if (!file.getName().endsWith(".xml")) continue;
                    try {
                        requisitions.add(this.getRequisition(file));
                    }
                    catch (ForeignSourceRepositoryException e) {
                        // empty catch block
                    }
                }
            }
            TreeSet<Requisition> treeSet = requisitions;
            return treeSet;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(String foreignSourceName) throws ForeignSourceRepositoryException {
        if (foreignSourceName == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            File inputFile = this.encodeFileName(this.m_requisitionPath, foreignSourceName);
            if (inputFile != null && inputFile.exists()) {
                Requisition requisition = this.getRequisition(inputFile);
                return requisition;
            }
            Requisition requisition = null;
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Requisition getRequisition(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("can't get a requisition with a null foreign source name!");
        }
        this.m_readLock.lock();
        try {
            Requisition requisition = this.getRequisition(foreignSource.getName());
            return requisition;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't save a null requisition!");
        }
        this.m_writeLock.lock();
        try {
            File outputFile = this.getOutputFileForRequisition(requisition);
            OutputStreamWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                if (this.m_updateDateStamps) {
                    requisition.updateDateStamp();
                }
                outputStream = new FileOutputStream(outputFile);
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
                JaxbUtils.marshal((Object)requisition, (Writer)writer);
            }
            catch (Throwable e) {
                try {
                    throw new ForeignSourceRepositoryException("unable to write requisition to " + outputFile.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        if (requisition == null) {
            throw new ForeignSourceRepositoryException("can't delete a null requisition!");
        }
        this.m_writeLock.lock();
        try {
            File deleteFile = this.getOutputFileForRequisition(requisition);
            if (deleteFile.exists() && !deleteFile.delete()) {
                throw new ForeignSourceRepositoryException("unable to delete requisition file " + deleteFile);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequisitionPath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_requisitionPath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeignSourcePath(String path) {
        this.m_writeLock.lock();
        try {
            this.m_foreignSourcePath = path;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public URL getRequisitionURL(String foreignSource) throws ForeignSourceRepositoryException {
        this.m_readLock.lock();
        try {
            URL uRL = this.getOutputFileForRequisition(this.getRequisition(foreignSource)).toURI().toURL();
            return uRL;
        }
        catch (MalformedURLException e) {
            throw new ForeignSourceRepositoryException("an error occurred getting the requisition URL", e);
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    private ForeignSource get(File inputFile) throws ForeignSourceRepositoryException {
        return (ForeignSource)JaxbUtils.unmarshal(ForeignSource.class, (File)inputFile);
    }

    private Requisition getRequisition(File inputFile) throws ForeignSourceRepositoryException {
        try {
            return (Requisition)JaxbUtils.unmarshal(Requisition.class, (File)inputFile);
        }
        catch (Throwable e) {
            throw new ForeignSourceRepositoryException("unable to unmarshal " + inputFile.getPath(), e);
        }
    }

    private void createPath(File fsPath) throws ForeignSourceRepositoryException {
        if (!fsPath.exists() && !fsPath.mkdirs()) {
            throw new ForeignSourceRepositoryException("unable to create directory " + fsPath.getPath());
        }
    }

    private File encodeFileName(String path, String foreignSourceName) {
        return new File(path, foreignSourceName + ".xml");
    }

    private File getOutputFileForForeignSource(ForeignSource foreignSource) {
        File fsPath = new File(this.m_foreignSourcePath);
        this.createPath(fsPath);
        return this.encodeFileName(this.m_foreignSourcePath, foreignSource.getName());
    }

    private File getOutputFileForRequisition(Requisition requisition) {
        File reqPath = new File(this.m_requisitionPath);
        this.createPath(reqPath);
        return this.encodeFileName(this.m_requisitionPath, requisition.getForeignSource());
    }
}

