/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import javax.xml.bind.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.test.mock.MockLogAppender;

public class RequisitionTest {
    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testRequisitionValidation() {
        ArrayList<RequisitionNode> nodes = new ArrayList<RequisitionNode>();
        Requisition req = new Requisition();
        req.updateDateStamp();
        req.updateLastImported();
        req.setForeignSource("foreignSource1");
        RequisitionNode foreignId1 = new RequisitionNode();
        foreignId1.setForeignId("foreignId1");
        foreignId1.setNodeLabel("foreign ID 1");
        nodes.add(foreignId1);
        req.setNodes(nodes);
        try {
            req.validate();
        }
        catch (ValidationException e) {
            Assert.fail();
        }
        RequisitionNode foreignId2 = new RequisitionNode();
        foreignId2.setForeignId("foreignId2");
        foreignId2.setNodeLabel("foreign ID 2");
        nodes.add(foreignId2);
        req.setNodes(nodes);
        try {
            req.validate();
        }
        catch (ValidationException e) {
            Assert.fail();
        }
        RequisitionNode duplicateId = new RequisitionNode();
        duplicateId.setForeignId("foreignId1");
        duplicateId.setNodeLabel("foreign ID 1 (duplicate)");
        nodes.add(duplicateId);
        req.setNodes(nodes);
        try {
            req.validate();
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((String)"error should say foreignId1 has a duplicate", (boolean)e.getMessage().contains("foreignId1"));
            Assert.assertTrue((String)"error should it found 2 errors", (boolean)e.getMessage().contains("foreignId1 (2 found)"));
        }
        nodes.add(duplicateId);
        req.setNodes(nodes);
        try {
            req.validate();
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((String)"error should say foreignId1 has a duplicate", (boolean)e.getMessage().contains("foreignId1"));
            Assert.assertTrue((String)"error count should now be 3", (boolean)e.getMessage().contains("foreignId1 (3 found)"));
        }
        nodes.add(foreignId2);
        req.setNodes(nodes);
        try {
            req.validate();
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertTrue((String)"error should say foreignId1 & 2 have duplicates", (e.getMessage().contains("foreignId1") && e.getMessage().contains("foreignId2") ? 1 : 0) != 0);
            Assert.assertTrue((String)"foreignId1 should still have 3 errors", (boolean)e.getMessage().contains("foreignId1 (3 found)"));
            Assert.assertTrue((String)"foreignId2 should have 2 errors", (boolean)e.getMessage().contains("foreignId2 (2 found)"));
        }
    }
}

