/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.persist.policies.NodeCategorySettingPolicy;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NodeCategoryPolicyTest {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DatabasePopulator m_populator;
    private List<OnmsNode> m_nodes;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_populator.populateDatabase();
        this.m_nodes = this.m_nodeDao.findAll();
    }

    @Test
    @Transactional
    public void testMatchingLabel() {
        NodeCategorySettingPolicy p = new NodeCategorySettingPolicy();
        p.setForeignId("1");
        p.setCategory("PolicyTest");
        List<OnmsNode> matchedNodes = this.matchPolicy(p, "1");
        Assert.assertTrue((boolean)matchedNodes.get(0).getCategories().contains(new OnmsCategory("PolicyTest")));
    }

    @Test
    @Transactional
    public void testMatchingNothing() {
        NodeCategorySettingPolicy p = new NodeCategorySettingPolicy();
        p.setLabel("~^wankerdoodle$");
        p.setCategory("PolicyTest");
        List<OnmsNode> matchedNodes = this.matchPolicy(p, null);
        Assert.assertEquals((long)0L, (long)matchedNodes.size());
    }

    private List<OnmsNode> matchPolicy(NodeCategorySettingPolicy p, String matchingId) {
        ArrayList<OnmsNode> populatedNodes = new ArrayList<OnmsNode>();
        ArrayList<OnmsNode> matchedNodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.m_nodes) {
            System.err.println(node);
            OnmsNode o = (OnmsNode)p.apply((Object)node);
            if (o != null && o.getCategories().contains(new OnmsCategory(p.getCategory()))) {
                matchedNodes.add(o);
            }
            if (!node.getNodeId().equals(matchingId)) continue;
            populatedNodes.add(node);
        }
        Assert.assertEquals(populatedNodes, matchedNodes);
        return matchedNodes;
    }
}

