/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.netmgt.provision.persist.AbstractForeignSourceRepository;
import org.opennms.netmgt.provision.persist.ForeignSourceRepositoryException;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.springframework.util.Assert;

public class MockForeignSourceRepository
extends AbstractForeignSourceRepository {
    private final Map<String, Requisition> m_requisitions = new HashMap<String, Requisition>();
    private final Map<String, ForeignSource> m_foreignSources = new HashMap<String, ForeignSource>();

    public Set<String> getActiveForeignSourceNames() {
        TreeSet<String> fsNames = new TreeSet<String>();
        fsNames.addAll(this.m_requisitions.keySet());
        fsNames.addAll(this.m_foreignSources.keySet());
        return fsNames;
    }

    public int getForeignSourceCount() {
        return this.m_foreignSources.size();
    }

    public Set<ForeignSource> getForeignSources() {
        return new TreeSet<ForeignSource>(this.m_foreignSources.values());
    }

    public ForeignSource getForeignSource(String foreignSourceName) {
        Assert.notNull((Object)foreignSourceName);
        ForeignSource foreignSource = this.m_foreignSources.get(foreignSourceName);
        if (foreignSource == null) {
            if (foreignSourceName == "default") {
                return super.getDefaultForeignSource();
            }
            return this.getDefaultForeignSource();
        }
        return foreignSource;
    }

    public void save(ForeignSource foreignSource) {
        Assert.notNull((Object)foreignSource);
        Assert.notNull((Object)foreignSource.getName());
        foreignSource.updateDateStamp();
        this.m_foreignSources.put(foreignSource.getName(), foreignSource);
    }

    public void delete(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        this.m_foreignSources.remove(foreignSource.getName());
    }

    public Set<Requisition> getRequisitions() throws ForeignSourceRepositoryException {
        return new TreeSet<Requisition>(this.m_requisitions.values());
    }

    public Requisition getRequisition(String foreignSourceName) {
        Assert.notNull((Object)foreignSourceName);
        return this.m_requisitions.get(foreignSourceName);
    }

    public Requisition getRequisition(ForeignSource foreignSource) {
        Assert.notNull((Object)foreignSource);
        Assert.notNull((Object)foreignSource.getName());
        return this.getRequisition(foreignSource.getName());
    }

    public void save(Requisition requisition) {
        Assert.notNull((Object)requisition);
        Assert.notNull((Object)requisition.getForeignSource());
        requisition.updateDateStamp();
        this.m_requisitions.put(requisition.getForeignSource(), requisition);
    }

    public void delete(Requisition requisition) throws ForeignSourceRepositoryException {
        this.m_requisitions.remove(requisition.getForeignSource());
    }

    public URL getRequisitionURL(String foreignSource) {
        throw new UnsupportedOperationException("no URL in the mock repository");
    }

    public ForeignSource getDefaultForeignSource() throws ForeignSourceRepositoryException {
        ForeignSource fs = this.getForeignSource("default");
        if (fs == null) {
            return super.getDefaultForeignSource();
        }
        return fs;
    }

    public void putDefaultForeignSource(ForeignSource foreignSource) throws ForeignSourceRepositoryException {
        if (foreignSource == null) {
            throw new ForeignSourceRepositoryException("foreign source was null");
        }
        foreignSource.setDefault(true);
        foreignSource.setName("default");
        foreignSource.updateDateStamp();
        this.save(foreignSource);
    }
}

