/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/testForeignSourceContext.xml"})
@JUnitConfigurationEnvironment
public class FusedForeignSourceRepositoryTest {
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pending;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_active;
    @Autowired
    @Qualifier(value="fused")
    private ForeignSourceRepository m_repository;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        for (ForeignSource fs : this.m_pending.getForeignSources()) {
            this.m_pending.delete(fs);
        }
        for (ForeignSource fs : this.m_active.getForeignSources()) {
            this.m_active.delete(fs);
        }
        for (Requisition r : this.m_pending.getRequisitions()) {
            this.m_pending.delete(r);
        }
        for (Requisition r : this.m_active.getRequisitions()) {
            this.m_active.delete(r);
        }
    }

    @Test
    public void integrationTest() {
        Requisition pendingReq = new Requisition("test");
        RequisitionNode node = new RequisitionNode();
        node.setForeignId("1");
        node.setNodeLabel("node label");
        RequisitionInterface iface = new RequisitionInterface();
        iface.setIpAddr("192.168.0.1");
        node.putInterface(iface);
        pendingReq.putNode(node);
        this.m_pending.save(pendingReq);
        ForeignSource pendingSource = this.m_repository.getForeignSource("test");
        Assert.assertTrue((boolean)pendingSource.isDefault());
        pendingSource.setDetectors(new ArrayList());
        this.m_pending.save(pendingSource);
        Requisition activeReq = this.m_repository.importResourceRequisition((Resource)new UrlResource(this.m_pending.getRequisitionURL("test")));
        ForeignSource activeSource = this.m_active.getForeignSource("test");
        Assert.assertEquals((Object)activeSource.getName(), (Object)pendingSource.getName());
        Assert.assertEquals((Object)activeSource.getDetectorNames(), (Object)pendingSource.getDetectorNames());
        Assert.assertEquals((Object)activeSource.getScanInterval(), (Object)pendingSource.getScanInterval());
        Assert.assertEquals((String)"the requisitions should match too", (Object)activeReq, (Object)pendingReq);
        System.err.println("requisition = " + this.m_pending.getRequisition("test"));
        Assert.assertNull((String)"the requisition should be null in the pending repo", (Object)this.m_pending.getRequisition("test"));
        Assert.assertTrue((String)"the foreign source should be default since there's no specific in the pending repo", (boolean)this.m_pending.getForeignSource("test").isDefault());
    }
}

