/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionVisitor;
import org.opennms.netmgt.provision.persist.TestVisitor;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/testForeignSourceContext.xml"})
@JUnitConfigurationEnvironment
public class FilesystemForeignSourceRepositoryTest {
    private String m_defaultForeignSourceName;
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_foreignSourceRepository;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.m_defaultForeignSourceName = "imported:";
    }

    private Requisition createRequisition() throws Exception {
        Requisition r = this.m_foreignSourceRepository.importResourceRequisition((Resource)new ClassPathResource("/requisition-test.xml"));
        this.m_foreignSourceRepository.save(r);
        return r;
    }

    private ForeignSource createForeignSource(String foreignSource) throws Exception {
        ForeignSource fs = new ForeignSource(foreignSource);
        fs.addDetector(new PluginConfig("HTTP", "org.opennms.netmgt.provision.detector.simple.HttpDetector"));
        fs.addPolicy(new PluginConfig("all-ipinterfaces", "org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy"));
        this.m_foreignSourceRepository.save(fs);
        return fs;
    }

    @Test
    public void testRequisition() throws Exception {
        this.createRequisition();
        Requisition r = this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName);
        TestVisitor v = new TestVisitor();
        r.visit((RequisitionVisitor)v);
        Assert.assertEquals((String)"number of nodes visited", (long)2L, (long)v.getNodeReqs().size());
        Assert.assertEquals((String)"node name matches", (Object)"apknd", (Object)v.getNodeReqs().get(0).getNodeLabel());
    }

    @Test
    public void testForeignSource() throws Exception {
        this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        Set foreignSources = this.m_foreignSourceRepository.getForeignSources();
        Assert.assertEquals((String)"number of foreign sources must be 1", (long)1L, (long)foreignSources.size());
        Assert.assertEquals((String)"getAll() foreign source name must match", (Object)this.m_defaultForeignSourceName, (Object)((ForeignSource)foreignSources.iterator().next()).getName());
        ForeignSource newForeignSource = this.m_foreignSourceRepository.getForeignSource(this.m_defaultForeignSourceName);
        Assert.assertEquals((Object)foreignSource.getName(), (Object)newForeignSource.getName());
        Assert.assertEquals((Object)foreignSource.getDateStampAsDate(), (Object)newForeignSource.getDateStampAsDate());
        Assert.assertEquals((Object)foreignSource.getDetectorNames(), (Object)newForeignSource.getDetectorNames());
        Assert.assertEquals((Object)foreignSource.getScanInterval(), (Object)newForeignSource.getScanInterval());
    }

    @Test
    public void testGetRequisition() throws Exception {
        Requisition requisition = this.createRequisition();
        ForeignSource foreignSource = this.createForeignSource(this.m_defaultForeignSourceName);
        Assert.assertEquals((String)"requisitions must match", (Object)this.m_foreignSourceRepository.getRequisition(this.m_defaultForeignSourceName), (Object)this.m_foreignSourceRepository.getRequisition(foreignSource));
        Assert.assertEquals((String)"foreign source is the expected one", (Object)requisition, (Object)this.m_foreignSourceRepository.getRequisition(foreignSource));
    }

    @Test
    public void testDefaultForeignSource() throws Exception {
        this.createRequisition();
        List<String> detectorList = Arrays.asList("DNS", "FTP", "HTTP", "HTTPS", "ICMP", "IMAP", "LDAP", "NRPE", "POP3", "SMTP", "SNMP", "SSH");
        String uuid = UUID.randomUUID().toString();
        ForeignSource defaultForeignSource = this.m_foreignSourceRepository.getForeignSource(uuid);
        Assert.assertEquals((String)"name must match requested foreign source repository name", (Object)uuid, (Object)defaultForeignSource.getName());
        Assert.assertEquals((String)"scan-interval must be 1 day", (long)86400000L, (long)defaultForeignSource.getScanInterval().getMillis());
        Assert.assertEquals((String)"foreign source must have no default policies", (long)0L, (long)defaultForeignSource.getPolicies().size());
        ArrayList<String> fsNames = new ArrayList<String>();
        for (PluginConfig config : defaultForeignSource.getDetectors()) {
            fsNames.add(config.getName());
        }
        Assert.assertEquals((String)"detector list must match expected defaults", detectorList, fsNames);
        Assert.assertTrue((String)"foreign source must be tagged as default", (boolean)defaultForeignSource.isDefault());
    }
}

