/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.spring.BeanUtils;
import org.opennms.features.geolocation.api.Coordinates;
import org.opennms.features.geolocation.api.GeolocationResolver;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class GeolocationProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(GeolocationProvisioningAdapter.class);
    private boolean enabled = Boolean.valueOf(System.getProperty("org.opennms.provisiond.resolveMissingCoordinatesFromAddressString", "true"));
    private NodeDao nodeDao;
    private ServiceRegistry serviceRegistry;

    public GeolocationProvisioningAdapter() {
        super("GeolocationProvisioningAdapter");
    }

    public void afterPropertiesSet() throws Exception {
        this.serviceRegistry = (ServiceRegistry)BeanUtils.getBean((String)"soaContext", (String)"serviceRegistry", ServiceRegistry.class);
        Objects.requireNonNull(this.nodeDao);
        Objects.requireNonNull(this.serviceRegistry);
    }

    @Override
    public void doAddNode(int nodeId) {
        LOG.debug("Invoked doAddNode on node with id {}.", (Object)nodeId);
        this.doUpdateNodeInternal(nodeId);
    }

    @Override
    public void doUpdateNode(int nodeId) {
        LOG.debug("Invoked doUpdateNode on node with id {}.", (Object)nodeId);
        this.doUpdateNodeInternal(nodeId);
    }

    @Override
    public void doDeleteNode(int nodeid) {
        LOG.debug("Invoked doDeleteNode on node with id {}. Nothing to do.", (Object)nodeid);
    }

    @Override
    public void doNotifyConfigChange(int nodeid) {
        LOG.debug("Invoked doNotifyConfigChange on node with id {}. Nothing to do.", (Object)nodeid);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    private OnmsNode getNode(int nodeId) {
        OnmsNode onmsNode = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (onmsNode == null) {
            throw new ProvisioningAdapterException("Node with id " + nodeId + " not found in database");
        }
        return onmsNode;
    }

    private GeolocationResolver getGeolocationResolver() {
        return (GeolocationResolver)this.serviceRegistry.findProvider(GeolocationResolver.class);
    }

    private void doUpdateNodeInternal(int nodeId) {
        if (!this.enabled || this.getGeolocationResolver() == null) {
            LOG.info("{} is either disabled manually or no GeocoderService is available (disabled={}, GeocoderService available={})", new Object[]{this.getName(), !this.enabled, this.getGeolocationResolver() != null});
            return;
        }
        OnmsNode node = this.getNode(nodeId);
        this.updateGeolocation(this.getGeolocationResolver(), node);
    }

    protected void updateGeolocation(GeolocationResolver geolocationResolver, OnmsNode node) {
        Objects.requireNonNull(geolocationResolver);
        Objects.requireNonNull(node);
        OnmsGeolocation geolocation = node.getAssetRecord().getGeolocation();
        if (geolocation != null && geolocation.getLatitude() == null && geolocation.getLatitude() == null && !Strings.isNullOrEmpty((String)geolocation.asAddressString())) {
            Coordinates coordinates = geolocationResolver.resolve(geolocation.asAddressString());
            if (coordinates != null) {
                geolocation.setLongitude(Float.valueOf(coordinates.getLongitude()));
                geolocation.setLatitude(Float.valueOf(coordinates.getLatitude()));
                this.nodeDao.saveOrUpdate((Object)node);
            } else {
                LOG.warn("Could not resolve address string '{}' for node with id {}", (Object)geolocation.asAddressString(), (Object)node.getId());
            }
        }
    }
}

