/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicDetector<Request, Response>
extends SyncAbstractDetector {
    private static final Logger LOG = LoggerFactory.getLogger(BasicDetector.class);
    private ClientConversation<Request, Response> m_conversation = new ClientConversation();

    protected BasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected BasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isServiceDetected(InetAddress address) {
        String ipAddr = InetAddressUtils.str((InetAddress)address);
        int port = this.getPort();
        int retries = this.getRetries();
        int timeout = this.getTimeout();
        LOG.info("isServiceDetected: Checking address: {} for {} capability on port {}", new Object[]{ipAddr, this.getServiceName(), this.getPort()});
        Client<Request, Response> client = this.getClient();
        for (int attempts = 0; attempts <= retries; ++attempts) {
            try {
                client.connect(address, port, timeout);
                LOG.info("isServiceDetected: Attempting to connect to address: {}, port: {}, attempt: #{}", new Object[]{ipAddr, port, attempts});
                if (!this.attemptConversation(client)) continue;
                boolean bl = true;
                return bl;
            }
            catch (ConnectException e) {
                LOG.info("isServiceDetected: {}: Unable to connect to address: {} port {}, attempt #{}", new Object[]{this.getServiceName(), ipAddr, port, attempts, e});
                continue;
            }
            catch (NoRouteToHostException e) {
                LOG.info("isServiceDetected: {}: No route to address {} was available", new Object[]{this.getServiceName(), ipAddr, e});
                continue;
            }
            catch (PortUnreachableException e) {
                LOG.info("isServiceDetected: {}: Port unreachable while connecting to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
                continue;
            }
            catch (InterruptedIOException e) {
                LOG.info("isServiceDetected: {}: Did not connect to address {} port {} within timeout: {} attempt: {}", new Object[]{this.getServiceName(), ipAddr, port, timeout, attempts, e});
                continue;
            }
            catch (IOException e) {
                LOG.error("isServiceDetected: {}: An unexpected I/O exception occured contacting address {} port {}", new Object[]{this.getServiceName(), ipAddr, port, e});
                continue;
            }
            catch (Throwable t) {
                LOG.error("isServiceDetected: {}: Unexpected error trying to detect {} on address {} port {}", new Object[]{this.getServiceName(), this.getServiceName(), ipAddr, port, t});
                continue;
            }
            finally {
                client.close();
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    protected abstract Client<Request, Response> getClient();

    private boolean attemptConversation(Client<Request, Response> client) throws IOException, Exception {
        return this.getConversation().attemptConversation(client);
    }

    protected final void expectBanner(ResponseValidator<Response> bannerValidator) {
        this.getConversation().expectBanner(bannerValidator);
    }

    protected final void send(RequestBuilder<Request> requestBuilder, ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(requestBuilder, responseValidator);
    }

    protected void send(Request request, ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(request, responseValidator);
    }

    protected final ClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

