/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.util.Map;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectFutureListener;
import org.opennms.netmgt.provision.support.AsyncBasicDetectorNettyImpl;

public class DetectFutureNettyImpl
implements DetectFuture {
    private final AsyncBasicDetectorNettyImpl<?, ?> m_detector;
    private final ChannelFuture m_future;

    public DetectFutureNettyImpl(AsyncBasicDetectorNettyImpl<?, ?> detector, ChannelFuture future) {
        this.m_detector = detector;
        this.m_future = future;
    }

    @Override
    public boolean isServiceDetected() {
        return this.m_future.isSuccess();
    }

    @Override
    public Map<String, String> getServiceAttributes() {
        return null;
    }

    @Override
    public Throwable getException() {
        return this.m_future.getCause();
    }

    @Override
    public void setServiceDetected(boolean serviceDetected) {
        if (serviceDetected) {
            this.m_future.setSuccess();
        } else {
            this.m_future.setFailure((Throwable)new ServiceDetectionFailedException());
        }
    }

    @Override
    public void setException(Throwable throwable) {
        this.m_future.setFailure(throwable);
    }

    @Override
    public void awaitFor() throws InterruptedException {
        this.m_future.await();
    }

    @Override
    public void awaitForUninterruptibly() {
        this.m_future.awaitUninterruptibly();
    }

    @Override
    public boolean isDone() {
        return this.m_future.isDone();
    }

    @Override
    public DetectFuture addListener(final DetectFutureListener<DetectFuture> listener) {
        final DetectFutureNettyImpl thisFuture = this;
        this.m_future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                listener.operationComplete(thisFuture);
            }
        });
        return this;
    }

    public static class ServiceDetectionFailedException
    extends Exception {
        private static final long serialVersionUID = -3784608501286028523L;
    }
}

