/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureNettyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorHandlerNettyImpl<Request, Response>
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorHandlerNettyImpl.class);
    private AsyncClientConversation<Request, Response> m_conversation;

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        LOG.debug("channelOpen()");
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            ctx.getChannel().write(request);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        LOG.debug("channelClosed()");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOG.debug("Caught a Throwable in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)event.getCause());
        ctx.getChannel().close();
        ctx.sendUpstream((ChannelEvent)event);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent message) {
        try {
            AsyncClientConversation<Request, Object> conversation = this.getConversation();
            LOG.debug("Client Receiving: {}", (Object)message.getMessage().toString().trim());
            LOG.debug("Conversation: {}", conversation);
            if (conversation.hasExchanges() && conversation.validate(message.getMessage())) {
                Request request = conversation.getRequest();
                if (request != null) {
                    LOG.debug("Writing request: {}", request);
                    ctx.getChannel().write(request);
                } else if (request == null && conversation.isComplete()) {
                    LOG.debug("Closing channel: {}", conversation);
                    ctx.getChannel().close();
                } else {
                    LOG.debug("Closing channel, detection failed: {}", conversation);
                    ctx.getChannel().close();
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                }
            } else {
                LOG.debug("Invalid response: {}", (Object)message.getMessage().toString().trim());
                ctx.getChannel().close();
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
            }
        }
        catch (Throwable e) {
            LOG.debug("Exception caught!", e);
            ctx.getChannel().close();
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
        }
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

