/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.support.AsyncBasicDetector;
import org.opennms.netmgt.provision.support.BaseDetectorHandler;
import org.opennms.netmgt.provision.support.ConnectionFactory;
import org.opennms.netmgt.provision.support.DetectFutureMinaImpl;
import org.opennms.netmgt.provision.support.trustmanager.RelaxedX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBasicDetectorMinaImpl<Request, Response>
extends AsyncBasicDetector<Request, Response> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBasicDetectorMinaImpl.class);
    private BaseDetectorHandler<Request, Response> m_detectorHandler = new BaseDetectorHandler();
    private IoFilterAdapter m_filterLogging = null;
    private ProtocolCodecFilter m_protocolCodecFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(CHARSET_UTF8));
    private final ConnectionFactory m_connectionFactory = ConnectionFactory.getFactory(this.getTimeout());

    public AsyncBasicDetectorMinaImpl(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetectorMinaImpl(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    @Override
    public void dispose() {
        LOG.debug("calling dispose on detector {}", (Object)this.getServiceName());
        ConnectionFactory.dispose(this.m_connectionFactory);
    }

    @Override
    public final DetectFuture isServiceDetected(InetAddress address) {
        DetectFutureMinaImpl detectFuture = new DetectFutureMinaImpl(this);
        try {
            final SSLContext c = AsyncBasicDetectorMinaImpl.createClientSSLContext();
            IoSessionInitializer<ConnectFuture> init = new IoSessionInitializer<ConnectFuture>(){

                public void initializeSession(IoSession session, ConnectFuture future) {
                    if (AsyncBasicDetectorMinaImpl.this.isUseSSLFilter()) {
                        SslFilter filter = new SslFilter(c);
                        filter.setUseClientMode(true);
                        session.getFilterChain().addFirst("SSL", (IoFilter)filter);
                    }
                    session.getFilterChain().addLast("logger", (IoFilter)(AsyncBasicDetectorMinaImpl.this.getLoggingFilter() != null ? AsyncBasicDetectorMinaImpl.this.getLoggingFilter() : new SlightlyMoreVerboseLoggingFilter()));
                    session.getFilterChain().addLast("codec", (IoFilter)AsyncBasicDetectorMinaImpl.this.getProtocolCodecFilter());
                    int idleTimeInSeconds = Math.max(1, Math.round((float)AsyncBasicDetectorMinaImpl.this.getIdleTime() / 1000.0f));
                    session.getConfig().setReaderIdleTime(idleTimeInSeconds);
                    session.getConfig().setWriterIdleTime(idleTimeInSeconds);
                    session.getConfig().setBothIdleTime(idleTimeInSeconds);
                }
            };
            InetSocketAddress socketAddress = new InetSocketAddress(address, this.getPort());
            ConnectFuture cf = this.m_connectionFactory.connect(socketAddress, (IoSessionInitializer<? extends ConnectFuture>)init, this.createDetectorHandler(detectFuture));
            cf.addListener(this.retryAttemptListener(detectFuture, socketAddress, init, this.getRetries()));
        }
        catch (KeyManagementException e) {
            detectFuture.setException(e);
        }
        catch (NoSuchAlgorithmException e) {
            detectFuture.setException(e);
        }
        catch (Throwable e) {
            detectFuture.setException(e);
        }
        return detectFuture;
    }

    private static final SSLContext createClientSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        return sslContext;
    }

    private final IoFutureListener<ConnectFuture> retryAttemptListener(final DetectFutureMinaImpl detectFuture, final InetSocketAddress address, final IoSessionInitializer<ConnectFuture> init, final int retryAttempt) {
        return new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                Throwable cause = future.getException();
                if (cause != null) {
                    if (cause instanceof IOException) {
                        if (retryAttempt == 0) {
                            LOG.info("Service {} detected false: {}: {}", new Object[]{AsyncBasicDetectorMinaImpl.this.getServiceName(), cause.getClass().getName(), cause.getMessage()});
                            detectFuture.setServiceDetected(false);
                        } else {
                            LOG.info("Connection exception occurred: {} for service {}, retrying attempt {}", new Object[]{cause, AsyncBasicDetectorMinaImpl.this.getServiceName(), retryAttempt});
                            future = AsyncBasicDetectorMinaImpl.this.m_connectionFactory.reConnect(address, (IoSessionInitializer<? extends ConnectFuture>)init, AsyncBasicDetectorMinaImpl.this.createDetectorHandler(detectFuture));
                            future.addListener(AsyncBasicDetectorMinaImpl.this.retryAttemptListener(detectFuture, address, (IoSessionInitializer<ConnectFuture>)init, retryAttempt - 1));
                        }
                    } else {
                        LOG.info("Threw a Throwable and detection is false for service {}", (Object)AsyncBasicDetectorMinaImpl.this.getServiceName(), (Object)cause);
                        detectFuture.setServiceDetected(false);
                    }
                }
            }
        };
    }

    protected final void setDetectorHandler(BaseDetectorHandler<Request, Response> detectorHandler) {
        this.m_detectorHandler = detectorHandler;
    }

    protected final IoHandler createDetectorHandler(DetectFutureMinaImpl future) {
        this.m_detectorHandler.setConversation(this.getConversation());
        this.m_detectorHandler.setFuture(future);
        return this.m_detectorHandler;
    }

    protected final void setLoggingFilter(IoFilterAdapter filterLogging) {
        this.m_filterLogging = filterLogging;
    }

    protected final IoFilterAdapter getLoggingFilter() {
        return this.m_filterLogging;
    }

    protected final void setProtocolCodecFilter(ProtocolCodecFilter protocolCodecFilter) {
        this.m_protocolCodecFilter = protocolCodecFilter;
    }

    protected final ProtocolCodecFilter getProtocolCodecFilter() {
        return this.m_protocolCodecFilter;
    }

    protected final IoHandler getDetectorHandler() {
        return this.m_detectorHandler;
    }

    private static class SlightlyMoreVerboseLoggingFilter
    extends LoggingFilter {
        protected Logger m_logger = LoggerFactory.getLogger((String)LoggingFilter.class.getName());

        public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
            if (IdleStatus.BOTH_IDLE.equals(status)) {
                this.m_logger.info("BOTH_IDLE");
            } else if (IdleStatus.READER_IDLE.equals(status)) {
                this.m_logger.info("READER_IDLE");
            } else if (IdleStatus.WRITER_IDLE.equals(status)) {
                this.m_logger.info("WRITER_IDLE");
            }
            nextFilter.sessionIdle(session, status);
        }
    }
}

