/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.opennms.netmgt.provision.support.AsyncAbstractDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.ConversationExchangeDefaultImpl;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;

public abstract class AsyncBasicDetector<Request, Response>
extends AsyncAbstractDetector {
    protected static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private int m_idleTime = 3000;
    private AsyncClientConversation<Request, Response> m_conversation = new AsyncClientConversation();
    private boolean useSSLFilter = false;

    public AsyncBasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected void expectBanner(ResponseValidator<Response> bannerValidator) {
        this.m_conversation.setHasBanner(true);
        this.m_conversation.addExchange(new ConversationExchangeDefaultImpl(null, bannerValidator));
    }

    protected void send(final Request request, ResponseValidator<Response> responseValidator) {
        this.m_conversation.addExchange(new ConversationExchangeDefaultImpl(new RequestBuilder<Request>(){

            @Override
            public Request getRequest() {
                return request;
            }
        }, responseValidator));
    }

    public final void setIdleTime(int idleTime) {
        this.m_idleTime = idleTime;
    }

    public final int getIdleTime() {
        return this.m_idleTime;
    }

    protected final AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }

    protected ResponseValidator<Response> startsWith(final String prefix) {
        return new ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return str.startsWith(prefix);
            }
        };
    }

    protected ResponseValidator<Response> find(final String regex) {
        return new ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return Pattern.compile(regex).matcher(str).find();
            }
        };
    }

    public final void setUseSSLFilter(boolean useSSLFilter) {
        this.useSSLFilter = useSSLFilter;
    }

    public final boolean isUseSSLFilter() {
        return this.useSSLFilter;
    }
}

